<?php
declare(strict_types=1);
require_once __DIR__ . '/system/core.php';
require_once __DIR__ . '/system/head.php';
?>

<style>
    .info-page {
        min-height: 100vh;
        background: #0f111a;
        padding: 40px 20px;
        display: flex;
        flex-direction: column;
        gap: 25px;
        font-family: 'Inter', sans-serif;
        color: #8b949e;
    }

    .info-block {
        background: var(--panel, #1c2128);
        border: 1px solid rgba(255, 255, 255, 0.05);
        border-radius: 25px;
        padding: 25px;
        line-height: 1.6;
    }

    .info-title {
        color: #fff;
        font-size: 1.2rem;
        font-weight: 800;
        text-transform: uppercase;
        margin-bottom: 15px;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .info-title::before {
        content: "";
        width: 4px;
        height: 20px;
        background: var(--accent, #2ecc71);
        border-radius: 2px;
    }

    .accent {
        color: var(--accent, #2ecc71);
        font-weight: 700;
    }

    .rule-item {
        margin-bottom: 12px;
        padding-left: 15px;
        border-left: 1px solid rgba(255, 255, 255, 0.1);
    }

    .btn-back {
        display: block;
        text-align: center;
        padding: 18px;
        background: rgba(255, 255, 255, 0.05);
        border-radius: 18px;
        color: #fff;
        text-decoration: none;
        font-weight: 700;
        text-transform: uppercase;
        font-size: 0.8rem;
    }
</style>

<div class="info-page">

    <!-- Описание игры -->
    <div class="info-block">
        <div class="info-title">О проекте</div>
        <p>
            <span class="accent">ВОЙНА БОГОВ</span> — это хардкорная браузерная MMORPG нового поколения, развернутая в сеттинге темного фэнтези 2026 года. 
        </p>
        <p>
            Здесь нет места слабым. Вы — павший герой, получивший шанс на перерождение. Развивайте свои характеристики, вступайте в могущественные кланы и сражайтесь за право занять трон на Олимпе. 
            Вас ждут бесконечные битвы, редкие артефакты и живое общение с тысячами игроков.
        </p>
    </div>

    <!-- Пользовательское соглашение -->
    <div class="info-block">
        <div class="info-title">Соглашение</div>
        
        <div class="rule-item">
            <b style="color: #eee;">1. Учетная запись:</b> Регистрируясь, вы обязуетесь хранить свой пароль в тайне. Один игрок — один персонаж (мультоводство карается баном).
        </div>

        <div class="rule-item">
            <b style="color: #eee;">2. Поведение:</b> В чатах запрещены прямые оскорбления, пропаганда ненависти и реклама сторонних ресурсов. Уважайте других воинов.
        </div>

        <div class="rule-item">
            <b style="color: #eee;">3. Игровой процесс:</b> Использование багов, сторонних скриптов или автоматизации (ботов) приводит к немедленной блокировке аккаунта без права обжалования.
        </div>

        <div class="rule-item">
            <b style="color: #eee;">4. Ответственность:</b> Администрация не несет ответственности за утерянные в ходе игровых сражений предметы. Игра предоставляется "как есть".
        </div>
    </div>

    <a href="/" class="btn-back">Вернуться к алтарю</a>

</div>

<?php require_once __DIR__ . '/system/foot.php'; ?>
