<?php
declare(strict_types=1);
require_once __DIR__ . '/../system/core.php';

if (!$user || $user['access'] < 1) { header("Location: /news/"); exit; }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = trim($_POST['title'] ?? '');
    $text = trim($_POST['text'] ?? '');
    $cat = $_POST['category'] ?? 'Событие';
    
    if ($title && $text) {
        $stmt = $db->prepare("INSERT INTO `news` (title, category, text, author, created_at) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$title, $cat, $text, $user['login'], time()]);
        header("Location: index.php");
        exit;
    }
}

require_once __DIR__ . '/../system/head.php';
?>

<div style="padding: 15px; max-width: 500px; margin: 0 auto;">
    <h3 style="color:#fff;">Новая публикация</h3>
    <form method="POST">
        <label style="color:gray; font-size:0.8rem;">Категория:</label><br>
        <select name="category" style="width:100%; background:#1c2128; border:1px solid #30363d; color:#fff; padding:10px; border-radius:8px; margin-bottom:15px;">
            <option value="Событие">Событие</option>
            <option value="Обновление">Обновление</option>
            <option value="Тех.работы">Тех.работы</option>
            <option value="Важное">Важное</option>
        </select>

        <label style="color:gray; font-size:0.8rem;">Заголовок:</label><br>
        <input type="text" name="title" required style="width:100%; background:#1c2128; border:1px solid #30363d; color:#fff; padding:10px; border-radius:8px; margin-bottom:15px;">

        <label style="color:gray; font-size:0.8rem;">Текст:</label><br>
        <textarea name="text" rows="8" required style="width:100%; background:#1c2128; border:1px solid #30363d; color:#fff; padding:10px; border-radius:8px; margin-bottom:15px;"></textarea>

        <button type="submit" style="width:100%; background:var(--accent); border:none; padding:12px; border-radius:8px; font-weight:bold; cursor:pointer;">Опубликовать</button>
    </form>
    <a href="index.php" style="display:block; text-align:center; margin-top:15px; color:gray; text-decoration:none;">Отмена</a>
</div>

<?php require_once __DIR__ . '/../system/foot.php'; ?>
