<?php
declare(strict_types=1);
require_once __DIR__ . '/../system/core.php';

if (!$user || (int)$user['access'] < 3) { header("Location: /profile.php"); exit; }
require_once __DIR__ . '/../system/head.php';

$edit_user = null;
$msg = '';

// 1. Поиск игрока
if (isset($_POST['search_nick'])) {
    $stmt = $db->prepare("SELECT * FROM users WHERE login = ? LIMIT 1");
    $stmt->execute([trim($_POST['search_nick'])]);
    $edit_user = $stmt->fetch();
    if (!$edit_user) $msg = "<div class='alert-error'>Игрок не найден!</div>";
}

// 2. Обновление данных
if (isset($_POST['update_user'])) {
    $target_id = (int)$_POST['target_id'];
    $new_access = (int)$_POST['new_access'];
    $new_str = (int)$_POST['new_str'];
    $new_hp = (int)$_POST['new_hp'];

    $db->prepare("UPDATE users SET access = ?, str = ?, hp_max = ? WHERE id = ?")
       ->execute([$new_access, $new_str, $new_hp, $target_id]);
    
    $msg = "<div class='alert-success'>Параметры игрока обновлены!</div>";
}
?>

<div class="admin-container">
    <div class="admin-header">
        <span class="admin-badge" style="background:#58a6ff; color:#fff;">USER EDITOR 2026</span>
        <h2>Редактор героев</h2>
    </div>

    <?= $msg ?>

    <!-- Форма поиска -->
    <div class="admin-card">
        <form method="post">
            <input type="text" name="search_nick" placeholder="Введите ник для поиска..." required class="admin-input">
            <button type="submit" class="admin-btn-blue">Найти игрока</button>
        </form>
    </div>

    <?php if ($edit_user): ?>
    <!-- Форма редактирования -->
    <div class="admin-card">
        <h3 style="color:#fff;">Редактирование: <?= htmlspecialchars($edit_user['login']) ?></h3>
        <form method="post">
            <input type="hidden" name="target_id" value="<?= $edit_user['id'] ?>">
            
            <label class="input-label">Доступ (0-Игрок, 2-Мд, 3-Адм)</label>
            <input type="number" name="new_access" value="<?= $edit_user['access'] ?>" class="admin-input">
            
            <label class="input-label">Сила (Базовая)</label>
            <input type="number" name="new_str" value="<?= $edit_user['str'] ?>" class="admin-input">
            
            <label class="input-label">Макс. HP</label>
            <input type="number" name="new_hp" value="<?= $edit_user['hp_max'] ?>" class="admin-input">
            
            <button type="submit" name="update_user" class="admin-btn-green">Сохранить изменения</button>
        </form>
    </div>
    <?php endif; ?>

    <a href="index.php" class="back-link">← Назад в меню</a>
</div>

<style>
    .admin-container { max-width: 450px; margin: 0 auto; padding: 10px; }
    .admin-card { background: #161b22; border: 1px solid #30363d; border-radius: 16px; padding: 20px; margin-bottom: 15px; }
    .admin-input { width: 100%; background: #0d1117; border: 1px solid #30363d; border-radius: 10px; padding: 12px; color: #fff; margin-bottom: 15px; }
    .input-label { font-size: 0.75rem; color: #8b949e; display: block; margin-bottom: 5px; }
    .admin-btn-blue { width: 100%; background: #21262d; color: #58a6ff; border: 1px solid #30363d; padding: 12px; border-radius: 10px; font-weight: bold; cursor: pointer; }
    .admin-btn-green { width: 100%; background: #238636; color: #fff; border: none; padding: 15px; border-radius: 10px; font-weight: bold; cursor: pointer; }
    .alert-success { color: #2ecc71; text-align: center; margin-bottom: 10px; }
    .alert-error { color: #ff4d4d; text-align: center; margin-bottom: 10px; }
    .back-link { display: block; text-align: center; color: #8b949e; text-decoration: none; font-size: 0.85rem; }
</style>

<?php require_once __DIR__ . '/../system/foot.php'; ?>
