<?php
declare(strict_types=1);
require_once __DIR__ . '/system/core.php'; 

// --- 1. PHP API LOGIC ---
if (isset($_GET['action'])) {
    header('Content-Type: application/json');
    if (!$user) { echo json_encode(['status' => 'error', 'message' => 'Авторизуйтесь']); exit; }

    // Авто-очистка (30 дней)
    $db->prepare("DELETE FROM `chat_messages` WHERE `created_at` < ?")->execute([time() - 2592000]);

    if ($_GET['action'] === 'send') {
        $message = trim($_POST['message'] ?? '');
        $flood_timeout = 3; 

        if (isset($_SESSION['last_chat_message_time']) && (time() - $_SESSION['last_chat_message_time'] < $flood_timeout)) {
            echo json_encode(['status' => 'error', 'message' => 'Подождите ' . $flood_timeout . ' сек.']);
            exit;
        }

        if (!empty($message)) {
            $message = htmlspecialchars(mb_substr($message, 0, 255));
            
            // Сохраняем сообщение
            $stmt = $db->prepare("INSERT INTO `chat_messages` (user_id, message, created_at) VALUES (?, ?, ?)");
            $stmt->execute([$user['id'], $message, time()]);

            // --- ЛОГИКА ОТВЕТОВ (Упоминаний) ---
            // Ищем в тексте конструкцию @Ник
            if (preg_match('/@([a-zA-Z0-9_а-яА-Я]+)/u', $message, $matches)) {
                $target_login = $matches[1];
                
                // Проверяем, существует ли такой пользователь
                $target = $db->prepare("SELECT id FROM `users` WHERE `login` = ? LIMIT 1");
                $target->execute([$target_login]);
                $target_user = $target->fetch();

                if ($target_user && (int)$target_user['id'] !== (int)$user['id']) {
                    $notif_text = "Игрок <b>{$user['login']}</b> ответил вам в чате.";
                    $db->prepare("INSERT INTO `user_notifications` (user_id, text, created_at) VALUES (?, ?, ?)")
                       ->execute([$target_user['id'], $notif_text, time()]);
                }
            }

            // Награда за сообщение
            $db->prepare("UPDATE `users` SET `gold` = `gold` + 10 WHERE `id` = ?")->execute([$user['id']]);

            $_SESSION['last_chat_message_time'] = time();
            echo json_encode(['status' => 'success']);
        }
        exit;
    }

    if ($_GET['action'] === 'get') {
        $stmt = $db->prepare("SELECT cm.message, u.login, u.access FROM `chat_messages` cm JOIN `users` u ON cm.user_id = u.id ORDER BY cm.created_at DESC LIMIT 50");
        $stmt->execute();
        $messages = array_reverse($stmt->fetchAll(PDO::FETCH_ASSOC));

        foreach ($messages as &$msg) {
            $msg['role_tag'] = ''; $msg['msg_class'] = '';
            if ($msg['access'] >= 2) { $msg['role_tag'] = '[Адм] '; $msg['role_class'] = 'role-admin'; $msg['msg_class'] = 'msg-staff'; }
            elseif ($msg['access'] == 1) { $msg['role_tag'] = '[Мд] '; $msg['role_class'] = 'role-mod'; $msg['msg_class'] = 'msg-staff'; }
            else { $msg['role_class'] = 'role-player'; }
            
            // Подсветка упоминаний для всех
            $msg['message'] = preg_replace('/(@[a-zA-Z0-9_а-яА-Я]+)/u', '<span class="mention">$1</span>', $msg['message']);
        }
        echo json_encode(['status' => 'success', 'messages' => $messages]);
        exit;
    }

    if ($_GET['action'] === 'get_notifications') {
        $stmt = $db->prepare("SELECT text, created_at FROM `user_notifications` WHERE user_id = ? ORDER BY id DESC LIMIT 5");
        $stmt->execute([$user['id']]);
        echo json_encode(['status' => 'success', 'list' => $stmt->fetchAll(PDO::FETCH_ASSOC)]);
        exit;
    }

    if ($_GET['action'] === 'get_top') {
        $time24 = time() - 86400;
        $stmt = $db->prepare("SELECT u.login, COUNT(cm.id) as cnt FROM `chat_messages` cm JOIN `users` u ON cm.user_id = u.id WHERE cm.created_at > ? GROUP BY cm.user_id ORDER BY cnt DESC LIMIT 1");
        $stmt->execute([$time24]);
        echo json_encode(['status' => 'success', 'top' => $stmt->fetch(PDO::FETCH_ASSOC)]);
        exit;
    }
    exit;
}

require_once __DIR__ . '/system/head.php'; 
?>

<style>
    .chat-container { max-width: 800px; margin: 0 auto; display: flex; flex-direction: column; height: 50vh; }
    .message-list { flex-grow: 1; overflow-y: auto; padding: 15px; background: var(--panel); border: 1px solid var(--border); border-radius: 8px; }
    .message { margin-bottom: 10px; border-bottom: 1px solid rgba(255,255,255,0.05); padding-bottom: 5px; font-size: 14px; }
    .message-sender { font-weight: bold; cursor: pointer; color: var(--accent); }
    .role-admin { color: #ff416c; } .role-mod { color: #00ff88; } .role-player { color: #ccc; }
    .msg-staff .message-text { color: #00ff88 !important; font-weight: bold; }
    .mention { color: #ffd700; font-weight: bold; background: rgba(255, 215, 0, 0.1); padding: 0 2px; border-radius: 3px; }
    .chat-form { display: flex; gap: 8px; margin-top: 10px; }
    .chat-input { flex-grow: 1; padding: 12px; background: var(--panel); border: 1px solid var(--border); color: #fff; border-radius: 6px; outline: none; }
    .chat-send-btn { padding: 10px 25px; background: var(--accent); border: none; color: #000; font-weight: bold; cursor: pointer; border-radius: 6px; }
    .notif-container { max-width: 800px; margin: 15px auto; background: var(--panel); border: 1px solid var(--border); border-radius: 8px; padding: 10px; }
    .notif-title { font-size: 14px; color: var(--accent); font-weight: bold; margin-bottom: 8px; border-bottom: 1px solid var(--border); padding-bottom: 5px; }
    .notif-item { font-size: 12px; color: #bbb; padding: 4px 0; border-bottom: 1px dotted rgba(255,255,255,0.05); }
    .notif-item b { color: #fff; }
</style>

<div class="game-wrapper">
    <div class="title-block">Глобальный Чат</div>

    <div style="max-width: 800px; margin: 0 auto 10px; display: flex; justify-content: space-between; font-size: 12px;">
        <span>🏆 Лидер чата: <b id="top-user" style="color: var(--accent);">...</b></span>
        <span>2026 год • Награда: <b style="color: #ffd700;">10 💰</b></span>
    </div>

    <div class="chat-container">
        <div id="message-list" class="message-list">Загрузка сообщений...</div>
        <form id="chat-form" class="chat-form">
            <input type="text" id="chat-input" class="chat-input" placeholder="Напишите @Ник для ответа..." autocomplete="off">
            <button type="submit" class="chat-send-btn">ОТПРАВИТЬ</button>
        </form>
    </div>

    <div class="notif-container">
        <div class="notif-title">📜 Журнал событий и ответов</div>
        <div id="notif-list"></div>
    </div>
</div>

<script>
const messageList = document.getElementById('message-list');
const chatForm = document.getElementById('chat-form');
const chatInput = document.getElementById('chat-input');

function reply(login) {
    chatInput.value = `@${login} ${chatInput.value}`;
    chatInput.focus();
}

async function loadMessages() {
    try {
        const response = await fetch('chat.php?action=get');
        const data = await response.json();
        if (data.status === 'success') {
            const isAtBottom = messageList.scrollHeight - messageList.scrollTop <= messageList.clientHeight + 100;
            messageList.innerHTML = data.messages.map(msg => `
                <div class="message ${msg.msg_class}">
                    <span class="message-sender ${msg.role_class}" onclick="reply('${msg.login}')">${msg.role_tag}${msg.login}:</span>
                    <span class="message-text">${msg.message}</span>
                </div>
            `).join('');
            if (isAtBottom) messageList.scrollTop = messageList.scrollHeight;
        }
    } catch (e) {}
}

async function loadData() {
    fetch('chat.php?action=get_top').then(r => r.json()).then(data => {
        if (data.top) document.getElementById('top-user').innerText = `${data.top.login} (${data.top.cnt})`;
    });
    fetch('chat.php?action=get_notifications').then(r => r.json()).then(data => {
        if (data.list) {
            document.getElementById('notif-list').innerHTML = data.list.map(n => `<div class="notif-item">• ${n.text}</div>`).join('');
        }
    });
}

chatForm.onsubmit = async (e) => {
    e.preventDefault();
    const text = chatInput.value.trim();
    if (!text) return;
    const formData = new FormData();
    formData.append('message', text);
    const response = await fetch('chat.php?action=send', { method: 'POST', body: formData });
    const data = await response.json();
    if (data.status === 'success') {
        chatInput.value = '';
        loadMessages();
        loadData();
    } else { alert(data.message); }
};

setInterval(loadMessages, 3000);
setInterval(loadData, 10000);
loadMessages();
loadData();
</script>

<?php require_once __DIR__ . '/system/foot.php'; ?>
