<?php
/**
 * Donate.php - Казна ордена (2026 Style)
 */
declare(strict_types=1);
require_once __DIR__ . '/../system/core.php';

if (!$user || (int)$user['clan_id'] === 0) {
    header("Location: index.php");
    exit;
}

$error = null;
$message = null;

// --- ЛОГИКА ВЗНОСА ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['donate_silver'])) {
    $amount = (int)($_POST['amount'] ?? 0);
    
    if ($amount <= 0) {
        $error = "🚫 Введите корректную сумму пожертвования.";
    } elseif ($user['silver'] < $amount) {
        $error = "🥈 У вас недостаточно серебра для такого взноса.";
    } else {
        // Проводим транзакцию
        $db->prepare("UPDATE `users` SET `silver` = `silver` - ? WHERE `id` = ?")->execute([$amount, $user['id']]);
        
        // Убедитесь, что колонка 'silver' существует в таблице 'clans'
        $db->prepare("UPDATE `clans` SET `silver` = `silver` + ? WHERE `id` = ?")->execute([$amount, $user['clan_id']]);
        
        // Обновляем данные в текущем объекте
        $user['silver'] -= $amount;
        $message = "✨ Вы внесли <b>" . number_format((float)$amount) . "</b> 🥈 в казну ордена!";
    }
}

require_once __DIR__ . '/../system/head.php';
?>

<style>
    .donate-wrapper { padding: 12px; max-width: 500px; margin: 0 auto; font-family: sans-serif; }
    
    /* Карточка казны */
    .treasury-card { background: linear-gradient(145deg, #222, #111); border: 1px solid #333; border-radius: 16px; padding: 20px; text-align: center; margin-bottom: 20px; }
    .treasury-title { color: #f1c40f; font-size: 1.2rem; margin-bottom: 10px; font-weight: bold; text-transform: uppercase; }
    .user-balance { background: #000; padding: 10px; border-radius: 8px; color: #bdc3c7; font-size: 0.9rem; display: inline-block; margin-bottom: 20px; border: 1px solid #222; }

    /* Форма ввода */
    .donate-form { margin-top: 10px; }
    .input-amount { width: 100%; padding: 15px; background: #1a1a1a; border: 2px solid #333; border-radius: 12px; color: #fff; font-size: 1.2rem; text-align: center; margin-bottom: 15px; box-sizing: border-box; }
    .input-amount:focus { border-color: #f1c40f; outline: none; }
    
    .btn-donate { background: linear-gradient(to bottom, #2ecc71, #27ae60); color: #fff; border: none; padding: 15px; border-radius: 12px; font-weight: bold; width: 100%; cursor: pointer; font-size: 1rem; }
    .btn-donate:active { transform: scale(0.98); }

    /* Блок навигации */
    .back-block { margin-top: 25px; }
    .back-link { background: #2a2a2a; padding: 12px; border-radius: 10px; color: #aaa; text-decoration: none; display: block; text-align: center; border: 1px solid #333; transition: 0.2s; }
    .back-link:hover { background: #333; color: #fff; }

    /* Уведомления */
    .alert { padding: 12px; border-radius: 10px; margin-bottom: 15px; text-align: center; font-size: 0.9rem; }
    .alert-err { background: rgba(231, 76, 60, 0.1); color: #ff7675; border: 1px solid rgba(231, 76, 60, 0.3); }
    .alert-ok { background: rgba(46, 204, 113, 0.1); color: #55efc4; border: 1px solid rgba(46, 204, 113, 0.3); }
</style>

<div class="donate-wrapper">
    
    <div class="treasury-card">
        <div style="font-size: 2.5rem; margin-bottom: 10px;">🪙</div>
        <div class="treasury-title">Казна Ордена</div>
        
        <div class="user-balance">
            <!-- ИСПРАВЛЕНИЕ ОШИБКИ: Приведение к типу float -->
            Ваш кошелек: <b style="color: #fff;"><?= number_format((float)$user['silver']) ?></b> 🥈
        </div>

        <?php if ($error): ?><div class="alert alert-err"><?= $error ?></div><?php endif; ?>
        <?php if ($message): ?><div class="alert alert-ok"><?= $message ?></div><?php endif; ?>

        <form method="POST" class="donate-form">
            <input type="number" name="amount" class="input-amount" placeholder="Сумма в серебре..." min="1" max="<?= (int)$user['silver'] ?>" required>
            <button type="submit" name="donate_silver" class="btn-donate">ПОПОЛНИТЬ КАЗНУ</button>
        </form>
        
        <p style="font-size: 0.75rem; color: #666; margin-top: 15px;">
            Вклады в казну помогают развивать орден и открывать новые улучшения.
        </p>
    </div>

    <!-- Блок возврата -->
    <div class="back-block">
        <a href="index.php" class="back-link">
            ← Вернуться в цитадель
        </a>
    </div>

</div>

<?php 
require_once __DIR__ . '/../system/foot.php'; 
?>
