<?php
/**
 * Logs.php - История событий ордена (2026 Style)
 */
declare(strict_types=1);
require_once __DIR__ . '/../system/core.php';

if (!$user || (int)$user['clan_id'] === 0) {
    header("Location: index.php");
    exit;
}

// Получаем последние 20 записей
$stmt = $db->prepare("SELECT * FROM `clan_logs` WHERE `clan_id` = ? ORDER BY `created_at` DESC LIMIT 20");
$stmt->execute([$user['clan_id']]);
$logs = $stmt->fetchAll();

require_once __DIR__ . '/../system/head.php';
?>

<style>
    .logs-wrapper { padding: 12px; max-width: 500px; margin: 0 auto; font-family: sans-serif; }
    
    .logs-container { background: #1a1a1a; border: 1px solid #333; border-radius: 16px; overflow: hidden; }
    .log-item { padding: 12px 15px; border-bottom: 1px solid #222; display: flex; justify-content: space-between; align-items: flex-start; }
    .log-item:last-child { border-bottom: none; }
    .log-item:nth-child(odd) { background: rgba(255,255,255,0.02); }

    .log-content { color: #ccc; font-size: 0.9rem; line-height: 1.4; flex: 1; padding-right: 10px; }
    .log-time { color: #555; font-size: 0.75rem; white-space: nowrap; margin-top: 2px; }
    
    .header-block { text-align: center; margin-bottom: 20px; }
    .header-block h3 { color: #f1c40f; margin: 0; text-transform: uppercase; letter-spacing: 1px; }

    .back-block { margin-top: 25px; }
    .back-link { background: #2a2a2a; padding: 12px; border-radius: 10px; color: #aaa; text-decoration: none; display: block; text-align: center; border: 1px solid #333; }
    
    .empty-state { padding: 40px; text-align: center; color: #444; font-style: italic; }
</style>

<div class="logs-wrapper">
    <div class="header-block">
        <h3>📜 Летопись Ордена</h3>
        <p style="color: #666; font-size: 0.8rem;">Последние события вашего союза</p>
    </div>

    <div class="logs-container">
        <?php if (empty($logs)): ?>
            <div class="empty-state">Летопись пока пуста...</div>
        <?php else: ?>
            <?php foreach ($logs as $log): ?>
                <div class="log-item">
                    <div class="log-content">
                        <?= $log['message'] ?>
                    </div>
                    <div class="log-time">
                        <?= date('H:i', $log['created_at']) ?>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>

    <div class="back-block">
        <a href="index.php" class="back-link">← Вернуться в цитадель</a>
    </div>
</div>

<?php 
require_once __DIR__ . '/../system/foot.php'; 
?>
