<?php
ini_set('display_errors', '1');
error_reporting(E_ALL);

echo "<h3>Диагностика системы:</h3>";

// 1. Проверка файла ядра
if (file_exists('core.php')) {
    echo "<span style='color:green'>+ core.php найден</span><br>";
    require_once 'core.php';
} else {
    die("<span style='color:red'>- Файл core.php НЕ НАЙДЕН. Переименуйте файл с настройками БД в core.php</span>");
}

// 2. Проверка соединения с БД
if (isset($db)) {
    echo "<span style='color:green'>+ Соединение с БД установлено</span><br>";
} else {
    die("<span style='color:red'>- Объект \$db не создан. Проверьте настройки в core.php</span>");
}

// 3. Проверка таблицы users
try {
    $res = $db->query("SELECT * FROM users LIMIT 1");
    echo "<span style='color:green'>+ Таблица users доступна</span><br>";
} catch (Exception $e) {
    echo "<span style='color:red'>- Ошибка таблицы: " . $e->getMessage() . "</span><br>";
}
