<?php
declare(strict_types=1);
require_once __DIR__ . '/system/core.php';

if (!$user) { header("Location: index.php"); exit; }

$msg = "";
$exchange_rate = 100; // 1 Gold = 100 Silver

// --- ЛОГИКА ОБМЕНА --- (Остается прежней для PRG)
if (isset($_POST['action']) && $_POST['action'] == 'gold_to_silver') {
    $amount = (int)($_POST['amount'] ?? 0);
    $redirect_msg = "";

    if ($amount > 0) {
        $cost_gold = $amount;
        $gain_silver = $amount * $exchange_rate;

        if ($user['gold'] >= $cost_gold) {
            $db->prepare("UPDATE users SET gold = gold - ?, silver = silver + ? WHERE id = ?")
               ->execute([$cost_gold, $gain_silver, $user['id']]);
            $redirect_msg = "msg=success&gold_spent=$cost_gold&silver_gained=$gain_silver";
        } else {
            $redirect_msg = "msg=error_gold";
        }
    } else {
        $redirect_msg = "msg=error_amount";
    }
    header("Location: exchange.php?$redirect_msg"); 
    exit;
}

// --- Обработка GET-сообщений после редиректа ---
if (isset($_GET['msg'])) {
    if ($_GET['msg'] == 'success') {
        $spent = (int)($_GET['gold_spent'] ?? 0);
        $gained = (int)($_GET['silver_gained'] ?? 0);
        $msg = "Вы обменяли **$spent 💰** на **$gained ⚪**.";
    } elseif ($_GET['msg'] == 'error_gold') {
        $msg = "Недостаточно золота для обмена.";
    } elseif ($_GET['msg'] == 'error_amount') {
        $msg = "Введите корректную сумму.";
    }
}


require_once __DIR__ . '/system/head.php';
?>

<div class="exchange-wrapper">
    <div class="header-section-custom">
        <h1 class="header-title-custom">ОБМЕН ВАЛЮТЫ</h1>
    </div>

    <?php if ($msg): ?>
        <div class="alert-info-custom <?= (isset($_GET['msg']) && $_GET['msg'] == 'success') ? 'alert-success' : 'alert-error' ?>">
            <?= $msg ?>
        </div>
    <?php endif; ?>
    
    <div class="currency-panel">
        <div class="currency-item">
            <span>💰 Золото:</span>
            <strong><?= $user['gold'] ?? 0 ?></strong>
        </div>
        <div class="currency-item">
            <span>⚪ Серебро:</span>
            <strong><?= $user['silver'] ?? 0 ?></strong>
        </div>
    </div>

    <!-- Обменный блок -->
    <div class="exchange-main-block">
        <div class="exchange-rate-display">
             1 💰 = <?= $exchange_rate ?> ⚪
        </div>
        
        <form method="POST" action="exchange.php" class="exchange-form">
            <input type="hidden" name="action" value="gold_to_silver">
            <label for="gold_amount" class="form-label">Сколько золота хотите обменять?</label>
            <input type="number" id="gold_amount" name="amount" placeholder="Введите сумму" min="1" required class="form-input">
            <button type="submit" class="btn-exchange-action">
                Обменять на серебро
            </button>
        </form>
    </div>

    <!-- ССЫЛКА НАЗАД В МАГАЗИН ВНИЗУ -->
    <div class="footer-nav-custom">
        <a href="shop.php" class="btn-footer-nav">Вернуться в магазин</a>
    </div>
</div>

<style>
    .exchange-wrapper { max-width: 500px; margin: 0 auto; padding: 15px; font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; color: #fff; }
    
    .header-section-custom { border-bottom: 2px solid #ffc107; padding-bottom: 10px; margin-bottom: 20px; }
    .header-title-custom { color: #ffc107; text-align: center; margin: 0; font-size: 1.5rem; text-transform: uppercase; }
    
    .alert-info-custom { padding: 12px; border-radius: 8px; text-align: center; margin-bottom: 15px; font-size: 0.9rem; font-weight: bold; }
    .alert-success { background: rgba(40, 167, 69, 0.2); border: 1px solid #28a745; color: #28a745; }
    .alert-error { background: rgba(220, 53, 69, 0.2); border: 1px solid #dc3545; color: #dc3545; }

    .currency-panel { display: flex; justify-content: space-around; background: #1c1f23; padding: 15px; border-radius: 10px; margin-bottom: 25px; border: 1px solid #2d333b; }
    .currency-item { display: flex; flex-direction: column; align-items: center; }
    .currency-item span { font-size: 0.8rem; color: #aaa; margin-bottom: 5px; }
    .currency-item strong { font-size: 1.1rem; color: #fff; }
    
    .exchange-main-block { background: #111418; padding: 30px 20px; border-radius: 15px; border: 1px solid #007bff; box-shadow: 0 0 20px rgba(0, 123, 255, 0.3); }
    
    .exchange-rate-display { text-align: center; font-size: 1.4rem; font-weight: bold; color: #ffc107; margin-bottom: 25px; padding: 10px; background: #2d333b; border-radius: 8px; }
    
    .form-label { display: block; margin-bottom: 10px; font-size: 0.9rem; color: #aaa; }
    .form-input { width: 100%; padding: 12px; border-radius: 5px; border: 1px solid #444; background: #333; color: white; margin-bottom: 20px; box-sizing: border-box; font-size: 1rem; }
    
    .btn-exchange-action { width: 100%; padding: 14px; border: none; border-radius: 5px; font-weight: bold; cursor: pointer; text-transform: uppercase; background: #ffc107; color: #000; font-size: 1rem; transition: background-color 0.3s; }
    .btn-exchange-action:hover { background: #e0a800; }
    
    /* Стили для нижней ссылки */
    .footer-nav-custom { margin-top: 30px; }
    .btn-footer-nav { display: block; width: 100%; text-decoration: none; padding: 12px; border-radius: 8px; font-weight: bold; text-align: center; background: #2d333b; color: #fff; border: 1px solid #444; transition: background-color 0.3s; }
    .btn-footer-nav:hover { background: #ffc107; color: #000; }
</style>

<?php require_once __DIR__ . '/system/foot.php'; ?>
