<?php
declare(strict_types=1);
require_once __DIR__ . '/system/core.php';

if (!$user) {
    header("Location: /index.php");
    exit;
}

// --- ЛОГИКА ПЕРЕХОДА ---
if (isset($_GET['go'])) {
    $new_loc = (int)$_GET['go'];
    // Проверяем, существует ли локация, прежде чем отправить туда игрока
    $check = $db->prepare("SELECT id FROM `locations` WHERE `id` = ?");
    $check->execute([$new_loc]);
    
    if ($check->fetch()) {
        $db->prepare("UPDATE `users` SET `loc` = ? WHERE `id` = ?")->execute([$new_loc, $user['id']]);
        header("Location: location.php");
        exit;
    }
}

require_once __DIR__ . '/system/head.php';

// 1. Получаем данные текущей локации игрока
$loc_id = (int)($user['loc'] ?? 1);
$stmt = $db->prepare("SELECT * FROM `locations` WHERE `id` = ?");
$stmt->execute([$loc_id]);
$loc = $stmt->fetch();

if (!$loc) {
    die("Ошибка: Локация с ID $loc_id не найдена в базе данных. Создайте её в админке.");
}

// 2. Получаем монстров этой локации
$mobs_stmt = $db->prepare("SELECT * FROM `mobs` WHERE `loc_id` = ? ORDER BY `level` ASC");
$mobs_stmt->execute([$loc_id]);
$mobs = $mobs_stmt->fetchAll();

// 3. Получаем список ВСЕХ остальных локаций для перемещения
$moves_stmt = $db->prepare("SELECT id, name FROM `locations` WHERE `id` != ? LIMIT 10");
$moves_stmt->execute([$loc_id]);
$available_moves = $moves_stmt->fetchAll();
?>

<style>
    .loc-container { padding: 10px; max-width: 500px; margin: 0 auto; }
    .loc-main-card { 
        background: #161b22; border: 1px solid #30363d; border-radius: 16px; 
        padding: 20px; margin-bottom: 15px; border-top: 4px solid var(--accent);
    }
    .loc-title { font-size: 1.4rem; color: #fff; font-weight: bold; margin-bottom: 5px; }
    .loc-desc { color: #8b949e; font-size: 0.85rem; line-height: 1.4; }

    .section-header { font-size: 0.7rem; color: var(--accent); text-transform: uppercase; font-weight: 900; margin: 15px 0 10px 5px; display: block; }

    /* Карточки объектов (мобы/ресурсы) */
    .action-row { 
        background: #0d1117; border: 1px solid #30363d; border-radius: 12px; 
        padding: 12px; margin-bottom: 8px; display: flex; justify-content: space-between; align-items: center; 
    }
    .action-info { flex-grow: 1; }
    .action-name { color: #fff; font-weight: bold; font-size: 0.9rem; }
    .action-sub { color: #58a6ff; font-size: 0.7rem; margin-top: 2px; }

    /* Кнопки */
    .btn-battle { background: #ff4d4d; color: #000; padding: 7px 15px; border-radius: 8px; text-decoration: none; font-size: 0.75rem; font-weight: 900; }
    .btn-gather { background: var(--success); color: #000; padding: 7px 15px; border-radius: 8px; text-decoration: none; font-size: 0.75rem; font-weight: 900; }
    .btn-move { 
        background: #1c2128; border: 1px solid #30363d; color: #fff; padding: 12px; 
        border-radius: 12px; text-decoration: none; display: block; margin-bottom: 6px; 
        font-size: 0.85rem; text-align: center; font-weight: bold;
    }
    .btn-move:active { transform: scale(0.98); background: #21262d; }
</style>

<div class="loc-container">
    <!-- Информация о локации -->
    <div class="loc-main-card">
        <div class="loc-title"><?= htmlspecialchars($loc['name']) ?></div>
        <div class="loc-desc"><?= htmlspecialchars($loc['description'] ?? 'Таинственное место без описания...') ?></div>
    </div>

    <!-- Блок ресурсов (если есть) -->
    <?php if (!empty($loc['resource_node'])): ?>
        <span class="section-header">🌿 Ресурсы окружения</span>
        <div class="action-row" style="border-left: 4px solid var(--success);">
            <div class="action-info">
                <div class="action-name"><?= htmlspecialchars($loc['resource_node']) ?></div>
                <div class="action-sub">Можно получить: <?= htmlspecialchars($loc['resource_item']) ?></div>
            </div>
            <a href="/gather.php" class="btn-gather">СОБРАТЬ</a>
        </div>
        
        <?php if (isset($_GET['success_gather'])): ?>
            <div style="background: rgba(46, 204, 113, 0.1); color: var(--success); padding: 8px; border-radius: 8px; font-size: 0.75rem; text-align: center; margin-bottom: 10px;">
                ✔ Добыто ресурсов: <?= (int)$_GET['success_gather'] ?> шт.
            </div>
        <?php endif; ?>
    <?php endif; ?>

    <!-- Блок монстров -->
    <span class="section-header">⚔️ Обитатели зоны</span>
    <?php if (empty($mobs)): ?>
        <div style="color: gray; font-size: 0.8rem; padding: 10px;">В этой глуши никого нет...</div>
    <?php else: ?>
        <?php foreach ($mobs as $m): ?>
            <div class="action-row" style="border-left: 4px solid #ff4d4d;">
                <div class="action-info">
                    <div class="action-name"><?= htmlspecialchars($m['name']) ?> <span style="color:gray; font-size:0.75rem;">[<?= $m['level'] ?> ур]</span></div>
                    <div class="action-sub">❤️ HP: <?= $m['hp'] ?> | ⚔️ ATK: <?= $m['atk'] ?></div>
                </div>
                <a href="/battle.php?id=<?= $m['id'] ?>" class="btn-battle">В БОЙ</a>
            </div>
        <?php endforeach; ?>
    <?php endif; ?>

    <!-- Блок переходов -->
    <span class="section-header">🚶 Пути в другие земли</span>
    <?php if (empty($available_moves)): ?>
        <div style="color: gray; font-size: 0.8rem; padding: 10px;">Путей отсюда не видно.</div>
    <?php else: ?>
        <?php foreach ($available_moves as $move): ?>
            <a href="?go=<?= $move['id'] ?>" class="btn-move">
                Перейти в <?= htmlspecialchars($move['name']) ?>
            </a>
        <?php endforeach; ?>
    <?php endif; ?>

    <div style="text-align: center; margin-top: 25px;">
        <a href="/main.php" style="color: #8b949e; text-decoration: none; font-size: 0.8rem;">← На главную площадь</a>
    </div>
</div>

<?php require_once __DIR__ . '/system/foot.php'; ?>
