<?php
declare(strict_types=1);
require_once __DIR__ . '/system/core.php';

if (!$user) { header("Location: /index.php"); exit; }

$player_id = isset($_GET['id']) ? (int)$_GET['id'] : $user['id'];

// Загружаем данные игрока
$stmt = $db->prepare("SELECT * FROM `users` WHERE `id` = ? LIMIT 1");
$stmt->execute([$player_id]);
$p = $stmt->fetch();

if (!$p) {
    require_once __DIR__ . '/system/head.php';
    echo "<div style='color:#ff416c; text-align:center; padding:50px;'>Персонаж не найден в летописях...</div>";
    require_once __DIR__ . '/system/foot.php';
    exit;
}

// --- ЛОГИКА ПРОВЕРКИ ЛИДЕРА (ДЛЯ ПРИГЛАШЕНИЯ) ---
$is_leader = false;
if ((int)($user['clan_id'] ?? 0) > 0) {
    $clan_stmt = $db->prepare("SELECT `leader_id` FROM `clans` WHERE `id` = ? LIMIT 1");
    $clan_stmt->execute([$user['clan_id']]);
    $clan_info = $clan_stmt->fetch();
    if ($clan_info && (int)$clan_info['leader_id'] === (int)$user['id']) {
        $is_leader = true;
    }
}

// --- ЛОГИКА СУМКИ ---
$inv_stmt = $db->prepare("SELECT COUNT(*) FROM `inventory` WHERE `user_id` = ?");
$inv_stmt->execute([$player_id]);
$items_count = (int)$inv_stmt->fetchColumn();

// --- ЛОГИКА КЛАНА ---
$clan_name = "Без клана";
if (!empty($p['clan_id'])) {
    $c_stmt = $db->prepare("SELECT `name` FROM `clans` WHERE `id` = ? LIMIT 1");
    $c_stmt->execute([$p['clan_id']]);
    $clan_data = $c_stmt->fetch();
    if ($clan_data) $clan_name = htmlspecialchars($clan_data['name']);
}

// --- ЛОГИКА ДОЛЖНОСТИ ---
$rank_name = "Игрок";
$rank_color = "#8b949e";
if ((int)($p['access'] ?? 0) >= 3) { $rank_name = "Админ"; $rank_color = "#ff416c"; }
elseif ((int)($p['access'] ?? 0) == 2) { $rank_name = "Модер"; $rank_color = "#ffcc00"; }

// Статус Онлайн и Опыт
$is_online = (isset($p['last_visit']) && (time() - (int)$p['last_visit'] < 300));
$exp_percent = ($p['exp_next'] > 0) ? min(100, round(($p['exp'] / $p['exp_next']) * 100)) : 0;

require_once __DIR__ . '/system/head.php';
?>

<style>
    .p-container { background: var(--bg); min-height: 100vh; padding: 15px; font-family: 'Inter', sans-serif; color: #fff; }
    .profile-header { display: flex; align-items: center; gap: 12px; margin-bottom: 20px; padding: 5px; }
    .status-dot { width: 10px; height: 10px; border-radius: 50%; box-shadow: 0 0 10px currentColor; }
    .dot-online { color: #2ecc71; background: #2ecc71; }
    .dot-offline { color: #ff416c; background: #ff416c; }
    .p-nick { font-size: 1.4rem; font-weight: 800; }
    .p-rank-badge { font-size: 0.65rem; font-weight: 900; text-transform: uppercase; padding: 3px 8px; border-radius: 8px; background: rgba(255,255,255,0.05); border: 1px solid currentColor; }

    .avatar-block { background: var(--panel); border-radius: 30px; padding: 25px; text-align: center; border: 1px solid rgba(255,255,255,0.05); margin-bottom: 15px; }
    .big-avatar { width: 90px; height: 90px; background: var(--bg); border-radius: 25px; margin: 0 auto 15px; display: flex; align-items: center; justify-content: center; font-size: 3rem; border: 1px solid rgba(255,255,255,0.05); }
    .p-clan-tag { color: var(--accent); font-size: 0.85rem; font-weight: 700; margin-bottom: 10px; display: block; }
    
    .p-action-link { display: block; font-size: 0.75rem; font-weight: 800; text-transform: uppercase; text-decoration: none; margin-bottom: 8px; letter-spacing: 0.5px; }
    
    .exp-bar { height: 6px; background: var(--bg); border-radius: 10px; overflow: hidden; width: 100%; max-width: 180px; margin: 10px auto; }
    .exp-fill { height: 100%; background: var(--accent); box-shadow: 0 0 10px var(--accent); }

    .stats-list { background: var(--panel); border-radius: 20px; border: 1px solid rgba(255,255,255,0.05); margin-bottom: 15px; overflow: hidden; }
    .stat-link { display: flex; justify-content: space-between; align-items: center; padding: 15px 20px; text-decoration: none; border-bottom: 1px solid rgba(255,255,255,0.02); }
    .stat-link:last-child { border-bottom: none; }
    .stat-label { color: #8b949e; font-size: 0.9rem; display: flex; align-items: center; gap: 10px; }
    .stat-value { color: #fff; font-weight: 700; }

    .bag-link-card { background: var(--panel); border-radius: 20px; border: 1px solid rgba(0, 212, 255, 0.2); margin-bottom: 15px; }
    .bag-action { display: flex; justify-content: space-between; align-items: center; padding: 18px 20px; text-decoration: none; }
    .bag-label { color: #fff; font-size: 0.95rem; font-weight: 700; display: flex; align-items: center; gap: 10px; }
    .bag-count { color: var(--accent); font-size: 0.85rem; font-weight: 800; }
    
    .sys-link { border: 1px solid rgba(255, 65, 108, 0.2); }
</style>

<div class="p-container">
    <!-- Шапка -->
    <div class="profile-header">
        <div class="status-dot <?= $is_online ? 'dot-online' : 'dot-offline' ?>"></div>
        <div class="p-nick"><?= htmlspecialchars($p['login']) ?></div>
        <div class="p-rank-badge" style="color: <?= $rank_color ?>;"><?= $rank_name ?></div>
    </div>

    <!-- Аватарный блок -->
    <div class="avatar-block">
        <div class="big-avatar">
            <?= ($p['id'] == $user['id']) ? '👑' : '🧙‍♂️' ?>
        </div>

        <span class="p-clan-tag">🛡️ <?= $clan_name ?></span>

        <!-- Ссылки для взаимодействия с игроком -->
        <?php if ($p['id'] !== $user['id']): ?>
            <div style="margin: 10px 0;">
                <a href="/gifts.php?id=<?= $p['id'] ?>" class="p-action-link" style="color: #ffcc00;">
                    🎁 Подарить подарок
                </a>
                
                <?php if ($is_leader && (int)$p['clan_id'] === 0): ?>
                    <a href="/clans.php?action=invite&user_id=<?= $p['id'] ?>" class="p-action-link" style="color: #2ecc71;">
                        🛡️ Пригласить в клан
                    </a>
                <?php endif; ?>
            </div>
        <?php endif; ?>

        <div class="exp-bar"><div class="exp-fill" style="width: <?= $exp_percent ?>%"></div></div>
        <div style="font-size: 0.7rem; color: #586069; font-weight: 700;">УРОВЕНЬ <?= (int)$p['level'] ?> (<?= $exp_percent ?>%)</div>
    </div>

    <!-- Характеристики -->
    <div class="stats-list">
        <div class="stat-link"><span class="stat-label">💪 Сила</span><span class="stat-value"><?= (int)$p['str'] ?></span></div>
        <div class="stat-link"><span class="stat-label">⚡ Ловкость</span><span class="stat-value"><?= (int)$p['agi'] ?></span></div>
        <div class="stat-link"><span class="stat-label">🛡️ Защита</span><span class="stat-value"><?= (int)$p['def'] ?></span></div>
        <div class="stat-link"><span class="stat-label">❤️ Жизнь</span><span class="stat-value"><?= (int)$p['hp_now'] ?> / <?= (int)$p['hp_max'] ?></span></div>
        <div class="stat-link"><span class="stat-label">💰 Золото</span><span class="stat-value" style="color:#ffcc00;"><?= number_format((int)$p['gold']) ?></span></div>
        <div class="stat-link"><span class="stat-label">🥈 Серебро</span><span class="stat-value" style="color:#ced4da;"><?= number_format((int)$p['silver']) ?></span></div>
    </div>

    <!-- Сумка -->
    <div class="bag-link-card">
        <a href="/bag.php?id=<?= $p['id'] ?>" class="bag-action">
            <div class="bag-label"><span>🎒</span> Сумка</div>
            <div class="bag-count"><?= $items_count ?> шт.</div>
        </a>
    </div>

    <!-- Настройки и Выход (только для себя) -->
    <?php if ($p['id'] == $user['id']): ?>
        <div class="stats-list">
            <a href="/settings" class="stat-link">
                <span class="stat-label">⚙️ Настройки</span>
                <span class="stat-value">»</span>
            </a>
            <a href="/exit.php" class="stat-link" style="border-top: 1px solid rgba(255,255,255,0.05);">
                <span class="stat-label" style="color: #ff416c;">🚪 Выход из игры</span>
                <span class="stat-value"></span>
            </a>
        </div>
    <?php endif; ?>

</div>

<?php require_once __DIR__ . '/system/foot.php'; ?>
