<?php
declare(strict_types=1);
require_once __DIR__ . '/system/core.php';
require_once __DIR__ . '/system/head.php';
?>

<style>
    .rules-page {
        min-height: 100vh;
        background: #0f111a;
        padding: 40px 20px;
        display: flex;
        flex-direction: column;
        gap: 20px;
        font-family: 'Inter', sans-serif;
    }

    .rules-block {
        background: var(--panel, #1c2128);
        border: 1px solid rgba(255, 255, 255, 0.05);
        border-radius: 30px;
        padding: 30px 25px;
        box-shadow: 0 15px 35px rgba(0,0,0,0.4);
    }

    .rules-title {
        color: #fff;
        font-size: 1.5rem;
        font-weight: 900;
        text-transform: uppercase;
        margin-bottom: 20px;
        text-align: center;
        background: linear-gradient(to right, #fff, #8b949e);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
    }

    .rule-section {
        margin-bottom: 25px;
    }

    .rule-header {
        color: var(--accent, #2ecc71);
        font-size: 0.8rem;
        font-weight: 800;
        text-transform: uppercase;
        letter-spacing: 1px;
        margin-bottom: 10px;
        display: flex;
        align-items: center;
        gap: 10px;
    }

    .rule-header::after {
        content: "";
        flex: 1;
        height: 1px;
        background: rgba(46, 204, 113, 0.2);
    }

    .rule-text {
        color: #8b949e;
        font-size: 0.9rem;
        line-height: 1.6;
    }

    .rule-text b {
        color: #eee;
    }

    .warning-box {
        background: rgba(231, 76, 60, 0.05);
        border: 1px solid rgba(231, 76, 60, 0.1);
        padding: 15px;
        border-radius: 15px;
        color: #e74c3c;
        font-size: 0.8rem;
        text-align: center;
        font-weight: 600;
    }

    .btn-back {
        display: block;
        width: 100%;
        padding: 18px;
        background: rgba(255, 255, 255, 0.03);
        border: 1px solid rgba(255, 255, 255, 0.05);
        border-radius: 18px;
        color: #fff;
        text-decoration: none;
        text-align: center;
        font-weight: 800;
        font-size: 0.8rem;
        text-transform: uppercase;
    }
</style>

<div class="rules-page">

    <div class="rules-block">
        <h2 class="rules-title">Кодекс Богов</h2>

        <!-- Раздел 1 -->
        <div class="rule-section">
            <div class="rule-header">I. Общие положения</div>
            <div class="rule-text">
                Регистрируясь в игре <b>Война Богов</b>, вы подтверждаете свое согласие с данным сводом правил. Незнание кодекса не освобождает от кары.
            </div>
        </div>

        <!-- Раздел 2 -->
        <div class="rule-section">
            <div class="rule-header">II. Игровой процесс</div>
            <div class="rule-text">
                1. <b>Мультоводство:</b> Одному игроку разрешено иметь только одного персонажа. Использование «твинков» для передачи ресурсов карается вечным баном всех аккаунтов.<br><br>
                2. <b>Автоматизация:</b> Любые кликеры, макросы и боты запрещены. Мы за честную битву.<br><br>
                3. <b>Баги:</b> О любой найденной ошибке нужно сообщить администрации. Использование багов в корыстных целях приравнивается к измене.
            </div>
        </div>

        <!-- Раздел 3 -->
        <div class="rule-section">
            <div class="rule-header">III. Общение</div>
            <div class="rule-text">
                Запрещены оскорбления родственников, разжигание розни и реклама сторонних проектов. В чате должна царить атмосфера войны, а не базарной брани.
            </div>
        </div>

        <div class="warning-box">
            НАРУШЕНИЕ ПРАВИЛ ВЕДЕТ К ИЗГНАНИЮ В ТАРТАР (ПОЖИЗНЕННЫЙ БАН).
        </div>
    </div>

    <a href="/" class="btn-back">Вернуться к входу</a>

</div>

<?php require_once __DIR__ . '/system/foot.php'; ?>
