<?php
declare(strict_types=1);
require_once __DIR__ . '/system/core.php';

if ($user) {
    header("Location: /main.php");
    exit;
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $login = trim($_POST['login'] ?? '');
    $code = trim($_POST['code'] ?? '');
    $new_pass = $_POST['new_password'] ?? '';

    if (empty($login) || empty($code) || empty($new_pass)) {
        $error = "ЗАПОЛНИТЕ ВСЕ ПОЛЯ";
    } elseif (mb_strlen($new_pass) < 6) {
        $error = "НОВЫЙ ПАРОЛЬ СЛИШКОМ КОРОТКИЙ";
    } else {
        // Ищем игрока по логину и секретному коду
        $stmt = $db->prepare("SELECT id FROM users WHERE login = ? AND recovery_code = ? LIMIT 1");
        $stmt->execute([$login, $code]);
        $target = $stmt->fetch();

        if ($target) {
            $hashed_pass = password_hash($new_pass, PASSWORD_DEFAULT);
            $update = $db->prepare("UPDATE users SET password = ? WHERE id = ?");
            $update->execute([$hashed_pass, $target['id']]);
            $success = "СИЛА ВЕРНУЛАСЬ! ПАРОЛЬ ИЗМЕНЕН.";
        } else {
            $error = "ЛОГИН ИЛИ СЕКРЕТНЫЙ КОД НЕВЕРНЫ";
        }
    }
}

require_once __DIR__ . '/system/head.php';
?>

<style>
    .recovery-page {
        min-height: 100vh;
        background: #0f111a;
        padding: 40px 20px;
        display: flex;
        flex-direction: column;
        gap: 20px;
        font-family: 'Inter', sans-serif;
    }

    .recovery-block {
        background: var(--panel, #1c2128);
        border: 1px solid rgba(255, 255, 255, 0.05);
        border-radius: 30px;
        padding: 30px 20px;
        box-shadow: 0 15px 35px rgba(0,0,0,0.4);
    }

    .title-small {
        color: #fff;
        text-align: center;
        font-weight: 900;
        text-transform: uppercase;
        letter-spacing: 2px;
        margin-bottom: 25px;
    }

    .input-field {
        width: 100%;
        background: #0d1117;
        border: 1px solid rgba(255, 255, 255, 0.1);
        padding: 18px;
        border-radius: 18px;
        color: #fff;
        font-size: 1rem;
        margin-bottom: 15px;
        box-sizing: border-box;
        text-align: center;
    }

    .btn-action {
        width: 100%;
        padding: 18px;
        border-radius: 18px;
        border: none;
        background: var(--accent, #2ecc71);
        color: #000;
        font-weight: 800;
        text-transform: uppercase;
        cursor: pointer;
    }

    .msg-box {
        padding: 15px;
        border-radius: 15px;
        text-align: center;
        font-size: 0.8rem;
        font-weight: 700;
        margin-bottom: 15px;
        border: 1px solid;
    }

    .err { background: rgba(231, 76, 60, 0.1); color: #e74c3c; border-color: rgba(231, 76, 60, 0.2); }
    .ok { background: rgba(46, 204, 113, 0.1); color: #2ecc71; border-color: rgba(46, 204, 113, 0.2); }

    .help-text {
        color: #8b949e;
        font-size: 0.75rem;
        text-align: center;
        line-height: 1.4;
    }
</style>

<div class="recovery-page">
    <div class="recovery-block">
        <div class="title-small">Восстановление</div>

        <?php if ($error) echo "<div class='msg-box err'>$error</div>"; ?>
        <?php if ($success) echo "<div class='msg-box ok'>$success</div>"; ?>

        <form method="POST">
            <input type="text" name="login" class="input-field" placeholder="ИМЯ ГЕРОЯ" required>
            <input type="text" name="code" class="input-field" placeholder="СЕКРЕТНЫЙ КОД" required autocomplete="off">
            <input type="password" name="new_password" class="input-field" placeholder="НОВЫЙ ПАРОЛЬ" required>
            
            <button type="submit" class="btn-action">СБРОСИТЬ ПАРОЛЬ</button>
        </form>

        <div class="help-text" style="margin-top: 20px;">
            Если вы не помните свой секретный код, обратитесь в <a href="/support.php" style="color: #2ecc71; text-decoration: none;">Поддержку</a>.
        </div>
    </div>

    <div style="text-align:center;">
        <a href="/login.php" style="color: #8b949e; text-decoration: none; font-size: 0.8rem; text-transform: uppercase;">← Вернуться к входу</a>
    </div>
</div>

<?php require_once __DIR__ . '/system/foot.php'; ?>
