<?php
declare(strict_types=1);
require_once __DIR__ . '/../system/core.php';

if (!$user) { header("Location: /index.php"); exit; }

require_once __DIR__ . '/../system/head.php';
?>

<style>
    .s-container { background: var(--bg); min-height: 100vh; padding: 15px; font-family: 'Inter', sans-serif; }
    
    .s-header { margin-bottom: 25px; padding: 10px 5px; }
    .s-title { font-size: 1.7rem; font-weight: 900; color: #fff; letter-spacing: -1px; }
    .s-user-info { display: flex; gap: 10px; margin-top: 5px; }
    .s-badge { font-size: 0.65rem; font-weight: 800; padding: 3px 8px; border-radius: 6px; background: rgba(255,255,255,0.05); color: #8b949e; text-transform: uppercase; }

    /* Группировка меню */
    .s-group-label { font-size: 0.7rem; font-weight: 800; color: #4a4f5a; text-transform: uppercase; letter-spacing: 1.5px; margin: 20px 0 10px 10px; }
    .s-group { background: var(--panel); border-radius: 28px; border: 1px solid rgba(255,255,255,0.05); overflow: hidden; box-shadow: 0 10px 30px rgba(0,0,0,0.2); }
    
    .s-item { 
        display: flex; justify-content: space-between; align-items: center; 
        padding: 18px 20px; text-decoration: none; color: #fff; 
        border-bottom: 1px solid rgba(255,255,255,0.02); transition: 0.2s; 
    }
    .s-item:last-child { border-bottom: none; }
    .s-item:active { background: rgba(255,255,255,0.03); }
    
    .s-label { display: flex; align-items: center; gap: 15px; font-size: 0.95rem; font-weight: 600; }
    .s-icon { font-size: 1.2rem; width: 25px; text-align: center; }
    .s-value { font-size: 0.75rem; color: var(--accent); font-weight: 700; background: rgba(0,212,255,0.05); padding: 2px 8px; border-radius: 6px; }
    .s-arrow { color: #30363d; font-size: 0.8rem; margin-left: 10px; }
</style>

<div class="s-container">
    <div class="s-header">
        <div class="s-title">Настройки</div>
        <div class="s-user-info">
            <span class="s-badge">ID: <?= (int)$user['id'] ?></span>
            <span class="s-badge" style="color: #ffcc00;">💰 <?= number_format((int)($user['gold'] ?? 0)) ?></span>
        </div>
    </div>

    <!-- Раздел: Аккаунт -->
    <div class="s-group-label">Безопасность и имя</div>
    <div class="s-group">
        <a href="/settings/password.php" class="s-item">
            <span class="s-label"><span class="s-icon">🔑</span> Пароль</span>
            <span style="display:flex; align-items:center;">
                <span class="s-value" style="color: #8b949e;">защищен</span>
                <span class="s-arrow">❯</span>
            </span>
        </a>
        <a href="/settings/rename.php" class="s-item">
            <span class="s-label"><span class="s-icon">📝</span> Имя героя</span>
            <span style="display:flex; align-items:center;">
                <span class="s-value"><?= htmlspecialchars((string)$user['login']) ?></span>
                <span class="s-arrow">❯</span>
            </span>
        </a>
    </div>
</div>

<?php require_once __DIR__ . '/../system/foot.php'; ?>
