<?php
declare(strict_types=1);
require_once __DIR__ . '/system/core.php';

if (!$user) {
    header("Location: /index.php");
    exit;
}

// Определяем тип сортировки
$sort = $_GET['sort'] ?? 'level';
// Доступные варианты: уровень, опыт и здоровье (hp_max)
$allowed_sorts = [
    'level' => 'level', 
    'exp'   => 'exp', 
    'hp'    => 'hp_max'
];

if (!array_key_exists($sort, $allowed_sorts)) {
    $sort = 'level';
}

$orderBy = $allowed_sorts[$sort];

// Запрос к БД 2026
try {
    $stmt = $db->prepare("
        SELECT id, login, level, exp, hp_max, access 
        FROM `users` 
        ORDER BY $orderBy DESC, level DESC 
        LIMIT 100
    ");
    $stmt->execute();
    $top_players = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Ошибка базы данных: убедитесь, что колонки 'level', 'exp' и 'hp_max' существуют в таблице users.");
}

require_once __DIR__ . '/system/head.php';
?>

<style>
    .top-container { padding: 10px; animation: fadeIn 0.5s ease-out; }
    
    .top-nav {
        display: grid;
        grid-template-columns: 1fr 1fr 1fr;
        gap: 8px;
        margin-bottom: 15px;
    }
    .nav-btn {
        background: var(--panel);
        border: 1px solid var(--border);
        color: rgba(255,255,255,0.6);
        padding: 10px 5px;
        border-radius: 12px;
        text-align: center;
        text-decoration: none;
        font-size: 0.7rem;
        font-weight: 800;
        text-transform: uppercase;
        transition: 0.3s;
    }
    .nav-btn.active {
        border-color: var(--accent);
        color: var(--accent);
        background: rgba(0, 212, 255, 0.05);
    }

    .top-list { display: flex; flex-direction: column; gap: 10px; }
    .top-item {
        background: var(--panel);
        border: 1px solid var(--border);
        border-radius: 15px;
        padding: 12px 15px;
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .top-1 { border-color: rgba(255, 204, 0, 0.4); background: linear-gradient(90deg, #1d1b16, #161b22); }
    
    .rank-circle {
        width: 30px; height: 30px; border-radius: 50%;
        background: rgba(255,255,255,0.05);
        display: flex; align-items: center; justify-content: center;
        font-weight: 900; font-size: 0.8rem; color: rgba(255,255,255,0.5);
    }
    .top-1 .rank-circle { background: var(--gold); color: #000; }

    .player-info { flex-grow: 1; }
    .player-name { font-weight: bold; color: #fff; font-size: 0.95rem; }
    
    .stat-line { font-size: 0.7rem; color: rgba(255,255,255,0.4); margin-top: 3px; }
    .stat-val { color: #fff; font-weight: bold; }

    .val-badge {
        background: rgba(255, 255, 255, 0.05);
        border: 1px solid var(--border);
        color: #fff;
        padding: 4px 10px;
        border-radius: 8px;
        font-weight: bold;
        font-size: 0.8rem;
        min-width: 50px;
        text-align: center;
    }
    .active-badge { border-color: var(--accent); color: var(--accent); background: rgba(0, 212, 255, 0.1); }

    @keyframes fadeIn { from { opacity: 0; } to { opacity: 1; } }
</style>

<div class="top-container">
    <div class="loc-card" style="margin-bottom: 15px; background: var(--bg-grad); border: 1px solid var(--border); border-radius: 20px; padding: 15px; display: flex; align-items: center; gap: 15px;">
        <div style="font-size: 1.8rem;">🏆</div>
        <div>
            <div style="font-weight: 800; color: #fff; font-size: 1.1rem;">Зал великих богов</div>
            <div style="font-size: 0.75rem; color: var(--gold); text-transform: uppercase;">Рейтинг 2026</div>
        </div>
    </div>

    <!-- Навигация -->
    <div class="top-nav">
        <a href="?sort=level" class="nav-btn <?= $sort === 'level' ? 'active' : '' ?>">Уровень</a>
        <a href="?sort=exp" class="nav-btn <?= $sort === 'exp' ? 'active' : '' ?>">Опыт</a>
        <a href="?sort=hp" class="nav-btn <?= $sort === 'hp' ? 'active' : '' ?>">Здоровье</a>
    </div>

    <div class="top-list">
        <?php 
        $rank = 1;
        foreach ($top_players as $p): 
            $special_class = ($rank === 1) ? 'top-1' : '';
        ?>
            <div class="top-item <?= $special_class ?>">
                <div class="rank-circle"><?= $rank ?></div>
                
                <div class="player-info">
                    <div class="player-name"><?= htmlspecialchars($p['login']) ?></div>
                    <div class="stat-line">
                        EXP: <span class="stat-val"><?= number_format((int)$p['exp']) ?></span> | 
                        HP: <span class="stat-val" style="color: #ff416c;"><?= (int)$p['hp_max'] ?></span>
                    </div>
                </div>

                <div class="val-badge active-badge">
                    <?php 
                    if ($sort === 'level') echo $p['level'] . ' Lvl';
                    elseif ($sort === 'exp') echo number_format((int)$p['exp']);
                    elseif ($sort === 'hp') echo $p['hp_max'] . ' ❤';
                    ?>
                </div>
            </div>
        <?php 
            $rank++;
        endforeach; 
        ?>
    </div>
</div>

<?php 
require_once __DIR__ . '/system/foot.php';
?>
