<?php
define('NTLCMS', 1);
$module = 'go';
include ('../system/start.php');
include ('../system/function.php');
include ('../system/antidos.php');
if (!$active){
header('Location: '.URL);
$_SESSION['fail'] = 'Вы не авторизированы!';
exit;
}
$id ? $id : header('Location: '.URL.'/site_list');
$row = DB :: run() -> query("select * from `sites` where `id` = ?", array($id)) -> fetch(PDO::FETCH_OBJ);
$info = DB :: run() -> query("select * from `users` where `login` = ? limit 1", array($row -> login)) -> fetch(PDO::FETCH_OBJ);    
$status = DB :: run() -> querySingle("select count(`id`) from `sites` where `login` = ? and `status` = ?", array($ulogin, 1));    
$error = null;
if (!DB :: run() -> querySingle("select * from `sites` where `id` = ?", array($id))){
$error.= 'Данной площадки не существует!<br/>';
} elseif ($info -> credit <= '0'){
$error.= 'У пользователя исчерпан лимит переходов!<br/>';
DB :: run() -> query("update `sites` set `active` = ? where `id` = ?", array(0, $id));
} elseif ($status == '0'){
$error.= 'У вас нет активных площадок!<br/>';
} elseif ($row -> active == '0'){
$error.= 'По данной площадке переходить нельзя!<br/>';
} elseif (DB :: run() -> querySingle("select (`url`) from `click` where `url` = ? and `login` = ?", array($row -> url, $ulogin))){
$_SESSION['fail'] = 'Вы уже переходили по данной площадке! Переход засчитан!';
header('Location: '.URL.'/site_list');
exit;
} elseif ($row -> login == $ulogin){
$error.= 'По своей площадке переходить запрещено!<br/>';
} elseif (DB :: run() -> querySingle("select (`time`) from `click` where `login` = ? and `time` > ?", array($ulogin, TIME - $set['timeclick']))){
$error.= 'На сайте нужно находиться не менее '.($set['timeclick']).' сек!<br/>';
$_SESSION['ban'] = TIME;
}
if ($error){
include ('../system/head.php');
echo '<div class="title"><center>Оповещение</center></div>';
echo '<div class="post"><center><i class="fa fa-close fa-fw"></i> '.$error.'</center></div>';
echo '<div class="block"><i class="fa fa-home fa-fw"></i> <a href="'.URL.'/cabinet">В кабинет</a> | <a href="'.URL.'/site_list">Просмотр ссылок</a></div>';
include ('../system/foot.php');
} else {
$confirmed = isset($_POST['confirm_view']) && $_POST['confirm_view'] == '1';
if (!$confirmed) {
echo "<!-- DEBUG: URL from database: " . htmlspecialchars($row->url) . " -->";
function getDisplayUrl($url) {
if (empty($url)) {
return $url;
}
$parsed = parse_url($url);
if ($parsed === false || !isset($parsed['host'])) {
$url = preg_replace('#^https?://#', '', $url);
$url = preg_replace('#^www\.#', '', $url);
$url = explode('/', $url)[0];
return $url;
}
return $parsed['host'];
}
$displayUrl = getDisplayUrl($row->url);
include ('../system/head.php');
echo '<div class="title"><b>'.razd.'Подтверждение просмотра</b></div>';
?>
<div class="post">
<center>
<p>Вы переходите на сайт: <strong><?= htmlspecialchars($displayUrl) ?></strong></p>
<p><b>Для получения вознаграждения необходимо:</b></p>
<p>Подтвердить просмотр после завершения таймера!</p>
<div id="timer-container" style="margin: 20px 0;">
<div id="timer" style="font-size: 24px; font-weight: bold; color: #e74c3c;">
<?= $set['timeclick'] ?> секунд
</div>
<div id="progress-bar" style="width: 100%; height: 10px; background: #f0f0f0; border-radius: 5px; margin: 10px 0;">
<div id="progress" style="width: 0%; height: 100%; background: #2ecc71; border-radius: 5px; transition: width 1s linear;"></div>
</div>
</div>
<form id="confirm-form" method="post" style="display: none;">
<input type="hidden" name="confirm_view" value="1">
<button type="submit" class="btn btn-success">
<i class="fa fa-check fa-fw"></i> Подтвердить просмотр
</button>
</form>
<div id="wait-message" style="margin: 10px 0;">
<i class="fa fa-clock-o fa-fw"></i> Пожалуйста, подождите...
</div>
</center>
</div>
<script>
document.addEventListener('DOMContentLoaded', function() {
var timerElement = document.getElementById('timer');
var progressElement = document.getElementById('progress');
var confirmForm = document.getElementById('confirm-form');
var waitMessage = document.getElementById('wait-message');
var totalTime = <?= $set['timeclick'] ?>;
var timeLeft = totalTime;
var progressInterval = 100;
var interval = setInterval(function() {
timeLeft--;
timerElement.textContent = timeLeft + ' секунд';
var progressPercent = ((totalTime - timeLeft) / totalTime) * 100;
progressElement.style.width = progressPercent + '%';
if (progressPercent < 50) {
progressElement.style.background = '#e74c3c';
} else if (progressPercent < 80) {
progressElement.style.background = '#f39c12';
} else {
progressElement.style.background = '#2ecc71';
}
if (timeLeft <= 0) {
clearInterval(interval);
timerElement.textContent = 'Время вышло!';
timerElement.style.color = '#2ecc71';
confirmForm.style.display = 'block';
waitMessage.style.display = 'none';
}
}, 1000);
});
</script>
<div class="block">
<i class="fa fa-home fa-fw"></i> 
<a href="<?= URL ?>/cabinet">В кабинет</a> | 
<a href="<?= URL ?>/site_list">Просмотр ссылок</a>
</div>
<?php
include ('../system/foot.php');
} else {
DB::run()->beginTransaction();
try {
$siteOwner = DB::run()->query("SELECT `credit` FROM `users` WHERE `login` = ? FOR UPDATE", array($row->login))->fetch(PDO::FETCH_OBJ);
$clicker = DB::run()->query("SELECT `credit` FROM `users` WHERE `login` = ? FOR UPDATE", array($ulogin))->fetch(PDO::FETCH_OBJ);
if ($siteOwner->credit < 1) {
throw new Exception('У владельца сайта недостаточно кредитов для оплаты перехода');
}
if ($_USER['privilege'] == '1'){
$cost = filter_var($set['privcost'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
} else {
$cost = filter_var($set['cost'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
}
DB::run()->query("UPDATE `users` SET `balans` = `balans` + ?, `myprofit` = `myprofit` + ?, `allprofit` = `allprofit` + ? WHERE `login` = ?", 
array($cost, $cost, $cost, $ulogin));
DB::run()->query("UPDATE `sites` SET `day` = `day` + ?, `all` = `all` + ? WHERE `id` = ?", array(1, 1, $row->id));
DB::run()->query("UPDATE `users` SET `click_day` = `click_day` + ?, `click_all` = `click_all` + ? WHERE `login` = ?", array(1, 1, $ulogin));
DB::run()->query("UPDATE `users` SET `credit` = `credit` - ? WHERE `login` = ?", array(1, $row->login));
DB::run()->query("INSERT INTO `click` (`url`, `site`, `login`, `time`, `ip`, `ua`) VALUES (?, ?, ?, ?, ?, ?)", 
array($row->url, $row->id, $ulogin, TIME, $ip, $ua));
$refpercent = 1 * ($set['refpercent'] / 100);
if (DB::run()->querySingle("SELECT * FROM `ref` WHERE `login` = ? LIMIT 1", array($ulogin))){
$ref = DB::run()->query("SELECT * FROM `ref` WHERE `login` = ? LIMIT 1", array($ulogin))->fetch(PDO::FETCH_OBJ);
DB::run()->query("UPDATE `ref` SET `day` = `day` + ?, `all` = `all` + ? WHERE `login` = ? LIMIT 1", 
array($refpercent, $refpercent, $ulogin));
DB::run()->query("UPDATE `users` SET `bank` = `bank` + ? WHERE `login` = ?", array($refpercent, $ref->who));
}
DB::run()->commit();
header('Location: http://'.checkout($row->url)); 
exit;
} catch (Exception $e) {
DB::run()->rollBack();
include ('../system/head.php');
echo '<div class="title"><center>Ошибка</center></div>';
echo '<div class="post"><center><i class="fa fa-close fa-fw"></i> Ошибка при обработке перехода: '.$e->getMessage().'</center></div>';
echo '<div class="block"><i class="fa fa-home fa-fw"></i> <a href="'.URL.'/cabinet">В кабинет</a> | <a href="'.URL.'/site_list">Просмотр ссылок</a></div>';
include ('../system/foot.php');
}
}
}
?>