<?php
define('NTLCMS', 1);
$module = 'panel';
include ('../system/start.php');
include ('../system/function.php');
include ('../system/antidos.php');
include ('../system/head.php');
################################################################################
if ($active && $_USER['admin'] == '1'){
################################################################################
echo '<div class="title"><b>'.razd.' Админ панель | IP whois</b></div>';
################################################################################

$ip = isset($_GET['ip']) ? filter_var($_GET['ip'], FILTER_VALIDATE_IP, FILTER_FLAG_IPV4) : false;

function whoisQuery($whoisserver, $domain){
$port = 43;
$timeout = 5;
$fp = @fsockopen($whoisserver, $port, $errno, $errstr, $timeout);

if(!$fp){
return false;
}

fputs($fp, $domain . "\r\n");
$out = '';

while (!feof($fp)) {
$out .= fgets($fp);
}

fclose($fp);
$res = "";

if ((strpos(strtolower($out), "error") === false) && (strpos(strtolower($out), "not allocated") === false)){
$rows = explode("\n", $out);
foreach ($rows as $row) {
$row = trim($row);
if (($row != '') && ($row{0} != '#') && ($row{0} != '%')) {
$res .= $row . "\n";
}
}
}
return $res;
}

if ($ip){
$whoisservers = array(
//"whois.afrinic.net",         // Africa - returns timeout error :-(
"whois.lacnic.net",            // Latin America and Caribbean - returns data for ALL locations worldwide :-)
"whois.apnic.net",             // Asia/Pacific only
"whois.arin.net",              // North America only
"whois.ripe.net"               // Europe, Middle East and Central Asia only
);

$results = array();

foreach ($whoisservers as $whoisserver){
$result = whoisQuery($whoisserver, $ip);
if ($result && !in_array($result, $results)){
$results[$whoisserver]= $result;
}
}

$res = "RESULTS FOUND: ".count($results);
foreach ($results as $whoisserver=>$result){
$res .= "\n\n-------------\nLookup results for ".$ip." from ".$whoisserver." server:\n\n" . $result;
}

$array = array(
'%'              => '#',
'inetnum:'       => '<span style="color:red">inetnum:</span>',
'netname:'       => '<span style="color:green">netname:</span>',
'descr:'         => '<span style="color:red">descr:</span>',
'country:'       => '<span style="color:red">country:</span>',
'admin-c:'       => '<span style="color:gray">admin-c:</span>',
'tech-c:'        => '<span style="color:gray">tech-c:</span>',
'status:'        => '<span style="color:gray">status:</span>',
'mnt-by:'        => '<span style="color:gray">mnt-by:</span>',
'mnt-lower:'     => '<span style="color:gray">mnt-lower:</span>',
'mnt-routes:'    => '<span style="color:gray">mnt-routes:</span>',
'source:'        => '<span style="color:gray">source:</span>',
'role:'          => '<span style="color:gray">role:</span>',
'address:'       => '<span style="color:green">address:</span>',
'e-mail:'        => '<span style="color:green">e-mail:</span>',
'nic-hdl:'       => '<span style="color:gray">nic-hdl:</span>',
'org:'           => '<span style="color:gray">org:</span>',
'person:'        => '<span style="color:green">person:</span>',
'phone:'         => '<span style="color:green">phone:</span>',
'remarks:'       => '<span style="color:gray">remarks:</span>',
'route:'         => '<span style="color:red"><b>route:</b></span>',
'origin:'        => '<span style="color:gray">origin:</span>',
'organisation:'  => '<span style="color:gray">organisation:</span>',
'org-name:'      => '<span style="color:red"><b>org-name:</b></span>',
'org-type:'      => '<span style="color:gray">org-type:</span>',
'abuse-mailbox:' => '<span style="color:red"><b>abuse-mailbox:</b></span>',
'mnt-ref:'       => '<span style="color:gray">mnt-ref:</span>',
'fax-no:'        => '<span style="color:green">fax-no:</span>',
'NetType:'       => '<span style="color:gray">NetType:</span>',
'Comment:'       => '<span style="color:gray">Comment:</span>'
);
$ipwhois = trim(htmlspecialchars($res));
$ipwhois = strtr($ipwhois, $array);
} else {
$ipwhois = '<center>Ошибка получения данных!</center>';
}
echo '<div class="menu"><small>'.nl2br($ipwhois).'</small></div>';

################################################################################
echo '<div class="block"><i class="fa fa-home fa-fw"></i> <a href="'.checkout($_SERVER['HTTP_REFERER']).'">Назад</a> | <a href="'.URL.'/cabinet">В кабинет</a> | <a href="'.URL.'/_control">Админ панель</a></div>';
################################################################################
} else {
echo '<div class="title"><b>'.razd.' Проверка прав доступа</b></div>';
echo '<div class="menu"><center><i class="fa fa-close fa-fw"></i> Доступ запрещен!</center></div>';
echo '<div class="block"><i class="fa fa-home fa-fw"></i> '.(isset($active) ? '<a href="'.URL.'/cabinet">В кабинет</a>' : '<a href="'.URL.'">На главную</a>').'</div>';
}

include ('../system/foot.php');
?>