<?php 
define('NTLCMS', 1);
$module = 'activation';
include ('../system/start.php');
include ('../system/function.php');
include ('../system/antidos.php');
$page_title = 'Страница активации аккаунта - клик клуба ' . strtoupper($_SERVER['HTTP_HOST']);
include ('../system/head.php');
if (!$active){
header('Location: '.URL);
$_SESSION['fail'] = 'Вы не авторизированы!'; 
exit;
} elseif ($_USER['active'] == '1'){
header('Location: '.URL); 
exit;
}
echo '<div class="title"><b>'.razd.' Активация аккаунта</b></div>';
$error = null;
function createAndSendActivationCode($login, $email) {
DB::run()->query("DELETE FROM `activate` WHERE `login` = ?", array($login));
$new_code = generateActivationCode();
DB::run()->query(
"INSERT INTO `activate` (`login`, `code`, `date`) VALUES (?, ?, ?)", 
array($login, $new_code, TIME)
);
logActivationSend($login, $new_code);
return sendActivationCode($email, $login, $new_code);
}
$activation_data = DB::run()->query("SELECT * FROM `activate` WHERE `login` = ?", array($ulogin))->fetch();
if (!$activation_data) {
createAndSendActivationCode($ulogin, $_USER['email']);
}
if (isset($_POST['resend'])) {
if (!checkResendLimit($ulogin)) {
$error = 'Превышен лимит отправки кодов. Попробуйте через час.';
} else {
if (createAndSendActivationCode($ulogin, $_USER['email'])) {
$_SESSION['success'] = 'Новый код активации отправлен на ваш email!';
} else {
$error = 'Ошибка при отправке email! Обратитесь к администратору.';
}
}
}
if (isset($_POST['code'])) {
$verify = isset($_POST['code']) ? trim(filter_var($_POST['code'], FILTER_SANITIZE_FULL_SPECIAL_CHARS)) : '';
if (empty($verify)) {
$error .= 'Введите код активации!<br/>';
} elseif (!preg_match('#^[a-zA-Z0-9_-]{10}$#', $verify)) {
$error .= 'Неверный формат кода активации!<br/>';
} else {
$activation_data = DB::run()->query("SELECT * FROM `activate` WHERE `code` = ? AND `login` = ?", array($verify, $ulogin))->fetch(PDO::FETCH_OBJ);
if (!$activation_data) {
$error .= 'Неверный код активации или код не принадлежит вашему аккаунту!<br/>';
} elseif (TIME - $activation_data->date > 86400) { // 24 часа
$error .= 'Срок действия кода активации истек!<br/>';
}
}
if ($error) {
echo '<div class="post"><center><i class="fa fa-close fa-fw"></i> '.$error.'</center></div>';
} else {
if (DB::run()->query("DELETE FROM `activate` WHERE `code` = ? AND `login` = ? LIMIT 1", array($verify, $ulogin))) {
DB::run()->query("UPDATE `users` SET `active` = ? WHERE `login` = ? LIMIT 1", array(1, $ulogin));
$_SESSION['success'] = 'Аккаунт успешно активирован!';
header('Location: '.URL);
exit;
} else {
echo '<div class="post"><center><i class="fa fa-close fa-fw"></i> Ошибка при активации аккаунта!</center></div>';
}
}
}
if (isset($_SESSION['success'])) {
echo '<div class="post"><center><i class="fa fa-check-circle fa-fw"></i> '.$_SESSION['success'].'</center></div>';
unset($_SESSION['success']);
} else {
echo '<div class="post"><center><i class="fa fa-check-circle fa-fw"></i> Код активации был отправлен на указанный вами EMAIL!</center></div>';
}
if (isset($error)) {
echo '<div class="post"><center><i class="fa fa-close fa-fw"></i> '.$error.'</center></div>';
}
$can_resend = checkResendLimit($ulogin);
$resend_count = DB::run()->querySingle(
"SELECT COUNT(*) FROM `activate_log` WHERE `login` = ? AND `date` > ?", 
array($ulogin, TIME - 3600)
);
echo '<div class="menu"><form name="form" action="'.URL.'/activation" method="post">
<b>* Введите код:</b><br/><input type="text" name="code" maxlength="10" value="'.(isset($_POST['code']) ? htmlspecialchars($_POST['code']) : '').'"/><br/>
<input type="submit" value="Активировать"/></form></div>';
if ($can_resend) {
echo '<div class="menu"><form name="resend" action="'.URL.'/activation" method="post">
<input type="hidden" name="resend" value="1"/>
<input type="submit" value="Отправить код повторно"/></form></div>';
} else {
echo '<div class="post"><center><i class="fa fa-info-circle fa-fw"></i> Лимит отправки исчерпан. Попробуйте позже.</center></div>';
}
echo '<div class="block"><i class="fa fa-home fa-fw"></i> <a href="'.URL.'/cabinet">В аккаунт</a></div>';
include ('../system/foot.php');
?>