<?php
define('NTLCMS', 1);
$module = 'asites';
include ('../system/start.php');
include ('../system/function.php');
include ('../system/antidos.php');
$page_title = 'Страница добавления площадки - клик клуба ' . strtoupper($_SERVER['HTTP_HOST']);
include ('../system/head.php');
if (!$active){
header('Location: '.URL);
$_SESSION['fail'] = 'Вы не авторизированы!';
exit;
}
echo '<div class="title"><b>'.razd.' Добавить площадку</b></div>';
$mysites = DB :: run() -> querySingle("select count(`id`) from `sites` where `login` = ?", array($ulogin));
if ($mysites >= $set['maxsite']){
header('Location: '.URL.'/site');
$_SESSION['fail'] = 'Лимит площадок исчерпан!';
exit;
}
$error = null;
if (isset($_POST['name']) && isset($_POST['url'])){                
$name = isset($_POST['name']) ? filter_var($_POST['name'], FILTER_SANITIZE_STRING) : false;
$url = isset($_POST['url']) ? filter_var($_POST['url'], FILTER_SANITIZE_URL) : false;
$clean_url = preg_replace('#^(http://|https://|ftp://|ftps://)#', '', $url);
if (empty($name)){
$error.= 'Введите название ссылки!<br/>';
} elseif (mb_strlen($name, 'UTF-8') < 5 || mb_strlen($name, 'UTF-8') > 50){
$error.= 'Название должно содержать от 5 до 50 символов!<br/>';
}
if (empty($url)){
$error.= 'Введите адрес сайта!<br/>';
} elseif (mb_strlen($clean_url, 'UTF-8') < 2 || mb_strlen($clean_url, 'UTF-8') > 50){
$error.= 'Адрес должен содержать от 2 до 50 символов!<br/>';
} elseif (preg_match("#^http://|https://|ftp://|ftps://#i", $url)){
$error.= 'Не указывайте протокол (http://, https://)! Вводите только домен сайта.<br/>';
} elseif (!preg_match("#^[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$#", $clean_url)){
$error.= 'Неверный формат адреса сайта! Пример: example.com<br/>';
} elseif (DB :: run() -> querySingle("select `url` from `sites` where `url` = ?", array($clean_url))){
$error.= 'Ссылка с таким адресом уже существует!<br/>';
}
if ($error){
echo '<div class="post"><center><i class="fa fa-close fa-fw"></i> '.$error.'</center></div>';
} else {
if (DB :: run() -> query("insert into `sites` (`login`, `name`, `url`, `date`, `active`, `status`) values (?, ?, ?, ?, ?, ?)", 
array($ilogin, $name, $clean_url, TIME, 0, 2))){
$_SESSION['success'] = 'Площадка успешно добавлена на модерацию!';
header('Location: '.URL.'/site');
exit;
} else {
$_SESSION['fail'] = 'Площадка не добавлена! Ошибка базы данных.';
header('Location: '.URL.'/site');
exit;
}
}
}
echo '<div class="menu"><form name="form" action="'.URL.'/site_add" method="post">
* <b>Название ссылки:</b><br/><input type="text" name="name" maxlength="50" value="'.(isset($_POST['name']) ? htmlspecialchars($_POST['name']) : '').'"/><br/>
* <b>Адрес сайта:</b><br/><input type="text" name="url" maxlength="50" value="'.(isset($_POST['url']) ? htmlspecialchars($_POST['url']) : '').'" placeholder="example.com"/><br/>
<small>Вводите только домен без http:// (например: example.com)</small><br/><br/>
<input type="submit" value="Добавить площадку"/></form></div>';
echo '<div class="block"><i class="fa fa-home fa-fw"></i> <a href="'.URL.'/cabinet">В кабинет</a> | <a href="'.URL.'/site">Мои площадки</a></div>';
include ('../system/foot.php');
?>