<?php
define('NTLCMS', 1);
$module = 'edit';
include ('../system/start.php');
include ('../system/function.php');
include ('../system/antidos.php');
include ('../system/head.php');
################################################################################
if (!$active){
header('Location: '.URL);
$_SESSION['fail'] = 'Вы не авторизированы!';
exit;
}
################################################################################
echo '<div class="title"><b>'.razd.' Изменить площадку</b></div>';
################################################################################

$id = isset($_GET['id']) ? filter_var($_GET['id'], FILTER_SANITIZE_NUMBER_INT) : '0';
				
$control = DB :: run() -> query("select * from `sites` where `login` = ? and `id` = ? limit 1", array($ilogin, $id)) -> fetch(PDO::FETCH_OBJ);				
				
if ($control -> status == '3'){				
header('Location: '.URL.'/site');
$_SESSION['fail'] = 'Действие запрещено!'; exit;
}				


$sql = DB :: run() -> query("select * from `sites` where `id` = ? and `login` = ?", array($id, $ilogin));

if (DB :: run() -> querySingle("select * from `sites` where `id` = ? and `login` = ?", array($id, $ilogin))){

$error = null;
				
if (isset($_POST['name']) && isset($_POST['url'])){				

$name = isset($_POST['name']) ? filter_var($_POST['name'], FILTER_SANITIZE_STRING) : false;
$url = isset($_POST['url']) ? filter_var($_POST['url'], FILTER_SANITIZE_URL) : false;
$type = isset($_POST['type']) ? filter_var($_POST['type'], FILTER_SANITIZE_NUMBER_INT) : '1';
$auto = isset($_POST['auto']) ? filter_var($_POST['auto'], FILTER_SANITIZE_NUMBER_INT) : '0';			

if (empty($name)){
          $error.= 'Введите название ссылки!<br/>';
} elseif (mb_strlen($name, 'UTF-8') < 5 or mb_strlen($name, 'UTF-8') > 50){
          $error.= 'Название должно содержать от 5 до 50 символов!!<br/>';
}

if (empty($url)){
          $error.= 'Введите адрес сайта!<br/>';
} elseif(!preg_match('#[a-zA-Zа-яА-Я0-9_-]{2,50}#i', $url)){
          $error.= 'Адрес должен содержать от 2 до 50 символов!!<br/>';
} elseif (preg_match("/^http:\/\/[a-zA-Z0-9\/.=?_-]+$/", $url)){
          $error.= 'Не верно введен адрес сайта!<br/>';
}/* elseif (DB :: run() -> querySingle("select (`url`) from `sites` where `url` = ?", array($url))){
          $error.= 'Ссылка с таким адресом уже существует!<br/>';
}*/

$url = preg_replace('#^(http://|ftp://|https://|ftps://)#', '', $url);

if ($error){
echo '<div class="post"><center>'.ico('fail.png','16|16').' '.$error.'</center></div>';
} else {
if (DB :: run() -> query("update `sites` set `login` = ?, `name` = ?, `url` = ?, `type` = ?, `auto` = ?, `active` = ?, `status` = ? where `id` = ?", array($ilogin, $name, $url, $type, $auto, 0, 2, $id))){

$_SESSION['success'] = 'Площадка успешно изменена!';
header('Location: '.URL.'/site');
} else {
echo '<div class="post"><center><i class="fa fa-close fa-fw"></i> Ошибка при изменении площадки!</center></div>';
}
}
}

$row = $sql -> fetch(PDO::FETCH_OBJ);
				
echo '<div class="menu"><form name="form" action="'.URL.'/site_edit'.ints($row -> id).'" method="post">
* <b>Название ссылки:</b><br/><input type="text" name="name" maxlength="50" value="'.checkout($row -> name).'"/><br/>
* <b>Адрес сайта:</b><br/><input type="text" name="url" maxlength="50" value="'.checkout($row -> url).'"/><br/>
* <b>Тип ссылки:</b><br/><select name="type">
<option value="1"'.select(1, $row -> type).'">WAP ссылка</option>
<option value="2"'.select(2, $row -> type).'">WEB ссылка</option>
<option value="3"'.select(3, $row -> type).'">IFRAME ссылка</option>
<option value="4"'.select(4, $row -> type).'">ALARM ссылка</option>
<option value="5"'.select(5, $row -> type).'">Для взрослых</option></select><br/>
<input type="checkbox" name="auto" value="1"'.check(1, $row -> auto).'"/><b>Автосерфинг</b><br/>
<input type="submit" value="Изменить площадку"/></form></div>';


echo '<div class="block"><i class="fa fa-home fa-fw"></i> <a href="'.URL.'/cabinet">В кабинет</a> | <a href="'.URL.'/site">Мои площадки</a></div>';

} else {
header('Location: '.URL.'/site');
}
				

include ('../system/foot.php');
?>