<?php
define('NTLCMS', 1);
include ('start.php');
include ('function.php');

if (!$active) {
    echo json_encode(['success' => false, 'error' => 'Не авторизован']);
    exit;
}

$click_id = isset($_POST['click_id']) ? intval($_POST['click_id']) : 0;
$id = isset($_POST['id']) ? intval($_POST['id']) : 0;

if ($click_id == 0 || $id == 0) {
    echo json_encode(['success' => false, 'error' => 'Неверные параметры']);
    exit;
}

DB::run()->beginTransaction();

try {
    // Проверяем существование временной записи
    $click = DB::run()->query("SELECT * FROM `click_temp` WHERE `id` = ? AND `login` = ? AND `completed` = ?", 
                             array($click_id, $ulogin, 0))->fetch(PDO::FETCH_OBJ);
    
    if (!$click) {
        throw new Exception('Запись о просмотре не найдена или уже обработана');
    }

    // Получаем информацию о сайте
    $site = DB::run()->query("SELECT * FROM `sites` WHERE `id` = ?", array($id))->fetch(PDO::FETCH_OBJ);
    
    if (!$site) {
        throw new Exception('Сайт не найден');
    }

    // Определяем стоимость перехода
    if ($_USER['privilege'] == '1'){
        $cost = filter_var($set['privcost'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
    } else {
        $cost = filter_var($set['cost'], FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
    }

    // Начисляем баллы пользователю
    DB::run()->query("UPDATE `users` SET `balans` = `balans` + ?, `myprofit` = `myprofit` + ?, `allprofit` = `allprofit` + ? WHERE `login` = ?", 
                    array($cost, $cost, $cost, $ulogin));

    // Обновляем статистику сайта
    DB::run()->query("UPDATE `sites` SET `day` = `day` + ?, `all` = `all` + ? WHERE `id` = ?", array(1, 1, $site->id));

    // Обновляем статистику пользователя
    DB::run()->query("UPDATE `users` SET `click_day` = `click_day` + ?, `click_all` = `click_all` + ? WHERE `login` = ?", array(1, 1, $ulogin));

    // Списываем кредиты у владельца сайта
    DB::run()->query("UPDATE `users` SET `credit` = `credit` - ? WHERE `login` = ?", array(1, $site->login));

    // Начисляем реферальные бонусы
    $refpercent = 1 * ($set['refpercent'] / 100);
    if (DB::run()->querySingle("SELECT * FROM `ref` WHERE `login` = ? LIMIT 1", array($ulogin))){
        $ref = DB::run()->query("SELECT * FROM `ref` WHERE `login` = ? LIMIT 1", array($ulogin))->fetch(PDO::FETCH_OBJ);
        DB::run()->query("UPDATE `ref` SET `day` = `day` + ?, `all` = `all` + ? WHERE `login` = ? LIMIT 1", 
                        array($refpercent, $refpercent, $ulogin));
        DB::run()->query("UPDATE `users` SET `bank` = `bank` + ? WHERE `login` = ?", array($refpercent, $ref->who));
    }

    // Переносим запись в основную таблицу
    DB::run()->query("INSERT INTO `click` (`url`, `site`, `login`, `time`, `ip`, `ua`) VALUES (?, ?, ?, ?, ?, ?)", 
                    array($click->url, $click->site, $click->login, $click->time, $click->ip, $click->ua));

    // Помечаем временную запись как обработанную
    DB::run()->query("UPDATE `click_temp` SET `completed` = ? WHERE `id` = ?", array(1, $click_id));

    DB::run()->commit();

    echo json_encode(['success' => true, 'amount' => $cost]);
    
} catch (Exception $e) {
    DB::run()->rollBack();
    echo json_encode(['success' => false, 'error' => $e->getMessage()]);
}
?>