<?php
// admin/notifications.php
require '../config/bootstrap.php';
require '../config/auth.php';

if (!isAdmin()) {
    http_response_code(403);
    die("Доступ запрещён");
}

require '../includes/header.php';
?>

<div class="container my-5">
    <h1 class="mb-4">📧 Отправка уведомлений клиентам</h1>

    <div class="glass p-4 card-ui fade-in">
        <form id="notificationForm">
            <div class="mb-3">
                <label>Кому:</label>
                <select id="recipient" class="form-select">
                    <option value="all">Все пользователи</option>
                    <?php
                    $users = $pdo->query("SELECT id, email FROM users ORDER BY email")->fetchAll(PDO::FETCH_ASSOC);
                    foreach ($users as $u) {
                        echo "<option value='{$u['id']}'>" . e($u['email']) . "</option>";
                    }
                    ?>
                </select>
            </div>
            <div class="mb-3">
                <label>Тема:</label>
                <input type="text" id="subject" class="form-control" required>
            </div>
            <div class="mb-3">
                <label>Сообщение:</label>
                <textarea id="message" class="form-control" rows="6" required></textarea>
            </div>
            <button type="submit" class="btn btn-primary">Отправить</button>
        </form>

        <div id="notificationResult" class="mt-3"></div>
    </div>
</div>

<script>
// AJAX отправка уведомления
document.getElementById('notificationForm').addEventListener('submit', function(e){
    e.preventDefault();

    const data = {
        recipient: document.getElementById('recipient').value,
        subject: document.getElementById('subject').value,
        message: document.getElementById('message').value,
        csrf: '<?= $_SESSION['csrf'] ?>'
    };

    fetch('/ajax/admin/send_notification.php', {
        method:'POST',
        headers:{'Content-Type':'application/json'},
        body: JSON.stringify(data)
    })
    .then(res=>res.json())
    .then(data=>{
        const resultDiv = document.getElementById('notificationResult');
        if(data.success){
            resultDiv.innerHTML = `<div class="alert alert-success">✅ Уведомление отправлено</div>`;
            document.getElementById('notificationForm').reset();
        } else {
            resultDiv.innerHTML = `<div class="alert alert-danger">❌ Ошибка: ${data.error}</div>`;
        }
    });
});
</script>

<?php require '../includes/footer.php'; ?>
