<?php
// admin/users.php
require '../config/bootstrap.php';
require '../config/auth.php';

if (!isAdmin()) {
    http_response_code(403);
    die("Доступ запрещён");
}

require '../includes/header.php';
?>

<div class="container my-5">
    <h1 class="mb-4">👥 Пользователи</h1>

    <div class="glass p-4 card-ui fade-in">
        <table class="table table-hover table-striped align-middle">
            <thead class="table-dark">
                <tr>
                    <th>#ID</th>
                    <th>Email</th>
                    <th>Имя</th>
                    <th>Роль</th>
                    <th>Дата регистрации</th>
                    <th>Действия</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $users = $pdo->query("SELECT id, email, name, role, created_at FROM users ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
                foreach ($users as $u):
                ?>
                <tr>
                    <td><?= e($u['id']) ?></td>
                    <td><?= e($u['email']) ?></td>
                    <td><?= e($u['name']) ?></td>
                    <td><?= e($u['role']) ?></td>
                    <td><?= e($u['created_at']) ?></td>
                    <td>
                        <button class="btn btn-sm btn-warning" onclick="editUser(<?= $u['id'] ?>)">✏️ Изменить</button>
                        <button class="btn btn-sm btn-danger" onclick="deleteUser(<?= $u['id'] ?>)">🗑️ Удалить</button>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
// Пример AJAX удаления пользователя
function deleteUser(userId){
    if(!confirm("Удалить пользователя?")) return;
    fetch('/ajax/admin/delete_user.php', {
        method: 'POST',
        headers: { 'Content-Type':'application/json' },
        body: JSON.stringify({id: userId, csrf: '<?= $_SESSION['csrf'] ?>'})
    })
    .then(res=>res.json())
    .then(data=>{
        if(data.success){
            alert('Пользователь удалён');
            location.reload();
        } else {
            alert('Ошибка: ' + data.error);
        }
    });
}

// Пример редактирования пользователя
function editUser(userId){
    window.location.href = '/admin/edit_user.php?id=' + userId;
}
</script>

<?php require '../includes/footer.php'; ?>
