<?php
// ajax/admin/approve_photo.php
require '../../config/bootstrap.php';
require '../../config/auth.php';

// Доступ только для администратора
if (!isAdmin()) {
    http_response_code(403);
    echo json_encode(['success'=>false, 'error'=>'Доступ запрещён']);
    exit;
}

// Получаем данные JSON
$data = json_decode(file_get_contents('php://input'), true);

// Проверка CSRF токена
if (empty($data['csrf']) || $data['csrf'] !== ($_SESSION['csrf'] ?? '')) {
    http_response_code(403);
    echo json_encode(['success'=>false, 'error'=>'Неверный CSRF токен']);
    exit;
}

// Получаем ID фотографии и новое состояние
$photo_id = intval($data['photo_id'] ?? 0);
$new_status = trim($data['status'] ?? '');

$valid_statuses = ['Одобрено','Отклонено'];

if (!$photo_id || !in_array($new_status, $valid_statuses)) {
    echo json_encode(['success'=>false, 'error'=>'Неверные данные']);
    exit;
}

// Обновляем статус фотографии
$stmt = $pdo->prepare("UPDATE photos SET status = ? WHERE id = ? LIMIT 1");
$updated = $stmt->execute([$new_status, $photo_id]);

if ($updated) {
    echo json_encode(['success'=>true, 'message'=>"Статус фотографии обновлён на '{$new_status}'"]);
} else {
    echo json_encode(['success'=>false, 'error'=>'Не удалось обновить статус']);
}
