<?php
// ajax/admin/update_status.php
require '../../config/bootstrap.php';
require '../../config/auth.php';

// Доступ только для администратора
if (!isAdmin()) {
    http_response_code(403);
    echo json_encode(['success'=>false, 'error'=>'Доступ запрещён']);
    exit;
}

// Получаем данные JSON
$data = json_decode(file_get_contents('php://input'), true);

// Проверка CSRF токена
if (empty($data['csrf']) || $data['csrf'] !== ($_SESSION['csrf'] ?? '')) {
    http_response_code(403);
    echo json_encode(['success'=>false, 'error'=>'Неверный CSRF токен']);
    exit;
}

// Получаем ID заказа и новый статус
$order_id = intval($data['order_id'] ?? 0);
$new_status = trim($data['status'] ?? '');

$valid_statuses = ['Новый','В обработке','Печать','Доставляется','Доставлен','Отменён'];

if (!$order_id || !in_array($new_status, $valid_statuses)) {
    echo json_encode(['success'=>false, 'error'=>'Неверные данные']);
    exit;
}

// Обновляем статус в базе
$stmt = $pdo->prepare("UPDATE orders SET status = ? WHERE id = ? LIMIT 1");
$updated = $stmt->execute([$new_status, $order_id]);

if ($updated) {
    echo json_encode(['success'=>true, 'message'=>'Статус заказа обновлён']);
} else {
    echo json_encode(['success'=>false, 'error'=>'Не удалось обновить статус']);
}
