<?php
// ajax/cart_add.php
require '../config/bootstrap.php';
require '../config/auth.php';

// Доступ только для авторизованных пользователей
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success'=>false, 'error'=>'Необходимо войти в систему']);
    exit;
}

// Получаем данные POST (JSON)
$data = json_decode(file_get_contents('php://input'), true);

// Проверка CSRF токена
if (empty($data['csrf']) || $data['csrf'] !== ($_SESSION['csrf'] ?? '')) {
    http_response_code(403);
    echo json_encode(['success'=>false, 'error'=>'Неверный CSRF токен']);
    exit;
}

// Валидация данных
$photo_id = intval($data['photo_id'] ?? 0);
$format   = trim($data['format'] ?? '');
$quantity = intval($data['quantity'] ?? 1);

if (!$photo_id || !$format || $quantity < 1) {
    echo json_encode(['success'=>false, 'error'=>'Неверные данные']);
    exit;
}

// Инициализация корзины
if (!isset($_SESSION['cart'])) {
    $_SESSION['cart'] = [];
}

// Формируем уникальный ключ для позиции
$item_key = $photo_id . '_' . md5($format);

// Если уже есть в корзине, увеличиваем количество
if (isset($_SESSION['cart'][$item_key])) {
    $_SESSION['cart'][$item_key]['quantity'] += $quantity;
} else {
    $_SESSION['cart'][$item_key] = [
        'photo_id' => $photo_id,
        'format'   => $format,
        'quantity' => $quantity,
        'added_at' => date('Y-m-d H:i:s')
    ];
}

echo json_encode([
    'success' => true,
    'cart_count' => count($_SESSION['cart']),
    'cart_items' => $_SESSION['cart']
]);
