<?php
// ajax/cart_update.php
require '../config/bootstrap.php';
require '../config/auth.php';

// Доступ только для авторизованных пользователей
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success'=>false, 'error'=>'Необходимо войти в систему']);
    exit;
}

// Получаем данные POST (JSON)
$data = json_decode(file_get_contents('php://input'), true);

// Проверка CSRF токена
if (empty($data['csrf']) || $data['csrf'] !== ($_SESSION['csrf'] ?? '')) {
    http_response_code(403);
    echo json_encode(['success'=>false, 'error'=>'Неверный CSRF токен']);
    exit;
}

// Получаем ключ позиции и новое количество
$item_key = trim($data['item_key'] ?? '');
$quantity = intval($data['quantity'] ?? 1);

if (!$item_key || !isset($_SESSION['cart'][$item_key])) {
    echo json_encode(['success'=>false, 'error'=>'Элемент не найден в корзине']);
    exit;
}

if ($quantity < 1) {
    echo json_encode(['success'=>false, 'error'=>'Количество должно быть больше 0']);
    exit;
}

// Обновляем количество
$_SESSION['cart'][$item_key]['quantity'] = $quantity;

echo json_encode([
    'success' => true,
    'cart_count' => count($_SESSION['cart']),
    'cart_items' => $_SESSION['cart']
]);
