<?php
// ajax/checkout.php
require '../config/bootstrap.php';
require '../config/auth.php';

// Проверка авторизации
if (!isset($_SESSION['user_id'])) {
    http_response_code(401);
    echo json_encode(['success'=>false, 'error'=>'Необходимо войти в систему']);
    exit;
}

// Получаем JSON данные
$data = json_decode(file_get_contents('php://input'), true);

// Проверка CSRF
if (empty($data['csrf']) || $data['csrf'] !== ($_SESSION['csrf'] ?? '')) {
    http_response_code(403);
    echo json_encode(['success'=>false, 'error'=>'Неверный CSRF токен']);
    exit;
}

// Проверка корзины
$cart = $_SESSION['cart'] ?? [];
if (empty($cart)) {
    echo json_encode(['success'=>false, 'error'=>'Корзина пуста']);
    exit;
}

// Данные пользователя для доставки
$delivery_address = trim($data['address'] ?? '');
$discount_code = trim($data['discount'] ?? '');

if (!$delivery_address) {
    echo json_encode(['success'=>false, 'error'=>'Введите адрес доставки']);
    exit;
}

// Начинаем транзакцию PDO
$pdo->beginTransaction();

try {
    $user_id = $_SESSION['user_id'];

    // Проверка скидочной карты
    $discount_percent = 0;
    if ($discount_code) {
        $stmt = $pdo->prepare("SELECT percent, active FROM discounts WHERE code = ? LIMIT 1");
        $stmt->execute([$discount_code]);
        $discount = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($discount && $discount['active']) {
            $discount_percent = floatval($discount['percent']);
        } else {
            $discount_code = null; // Неактивная или неверная скидка
        }
    }

    // Вставка каждого товара из корзины в таблицу orders
    foreach ($cart as $key => $item) {
        // Получаем цену формата
        $stmt = $pdo->prepare("SELECT price FROM formats WHERE name = ? LIMIT 1");
        $stmt->execute([$item['format']]);
        $format = $stmt->fetch(PDO::FETCH_ASSOC);
        if (!$format) {
            throw new Exception('Неверный формат: ' . e($item['format']));
        }

        $price = $format['price'];
        // Применяем скидку
        if ($discount_percent > 0) {
            $price = $price * (1 - $discount_percent / 100);
        }

        $stmt = $pdo->prepare("INSERT INTO orders 
            (user_id, photo_id, format, quantity, price, discount_code, status, delivery_address,
