<?php
// =========================
// config/bootstrap.php
// =========================

// -------------------------
// Настройки ошибок
// -------------------------
ini_set('display_errors', 0); // выключаем вывод ошибок на проде
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/../logs/error.log');
error_reporting(E_ALL);

// -------------------------
// Старт сессии
// -------------------------
if (session_status() == PHP_SESSION_NONE) {
    session_start([
        'cookie_lifetime' => 86400,
        'cookie_httponly' => true,
        'cookie_samesite' => 'Strict',
        'use_strict_mode' => true
    ]);
}

// -------------------------
// CSRF токен
// -------------------------
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}
define('CSRF_TOKEN', $_SESSION['csrf_token']);

// -------------------------
// Подключение к базе данных через PDO
// -------------------------
$db_host = 'localhost';
$db_name = 'rrr';
$db_user = 'root';
$db_pass = '333333';
$db_charset = 'utf8mb4';

$dsn = "mysql:host=$db_host;dbname=$db_name;charset=$db_charset";
$options = [
    PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    PDO::ATTR_EMULATE_PREPARES   => false,
];

try {
    $pdo = new PDO($dsn, $db_user, $db_pass, $options);
} catch (PDOException $e) {
    error_log($e->getMessage());
    die('Ошибка подключения к базе данных.');
}

// -------------------------
// Функции безопасности
// -------------------------

/**
 * Проверка CSRF токена
 */
function check_csrf($token) {
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}

/**
 * Экранирование вывода для XSS
 */
function e($string) {
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}

/**
 * Проверка авторизации пользователя
 */
function is_logged_in() {
    return isset($_SESSION['user_id']);
}

/**
 * Проверка роли администратора
 */
function is_admin() {
    return isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin';
}

/**
 * Редирект на страницу с безопасным header
 */
function redirect($url) {
    header("Location: $url");
    exit;
}

// -------------------------
// Настройки временной зоны
// -------------------------
date_default_timezone_set('Europe/Chisinau');

// -------------------------
// Глобальные константы
// -------------------------
define('BASE_URL', '/'); // корень проекта
define('UPLOAD_DIR', __DIR__ . '/../uploads/');
define('ASSETS_DIR', BASE_URL . 'assets/');

?>
