<?php
// =========================
// config/functions.php
// =========================

require_once __DIR__ . '/bootstrap.php';

// -------------------------
// Безопасный вывод для XSS
// -------------------------
function e($string) {
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}

// -------------------------
// Редирект
// -------------------------
function redirect($url) {
    header("Location: $url");
    exit;
}

// -------------------------
// Генерация случайного токена (например для CSRF или скидок)
// -------------------------
function random_token($length = 32) {
    return bin2hex(random_bytes($length));
}

// -------------------------
// Проверка email
// -------------------------
function is_valid_email($email) {
    return filter_var($email, FILTER_VALIDATE_EMAIL) !== false;
}

// -------------------------
// Проверка номера телефона
// -------------------------
function is_valid_phone($phone) {
    return preg_match('/^\+?\d{7,15}$/', $phone);
}

// -------------------------
// Форматирование даты
// -------------------------
function format_date($datetime, $format = 'd.m.Y H:i') {
    $dt = new DateTime($datetime);
    return $dt->format($format);
}

// -------------------------
// Генерация уникального имени файла для загрузки
// -------------------------
function unique_filename($filename) {
    $ext = pathinfo($filename, PATHINFO_EXTENSION);
    $name = bin2hex(random_bytes(8));
    return $name . '.' . $ext;
}

// -------------------------
// Преобразование статуса заказа в красивый HTML badge
// -------------------------
function status_badge($status) {
    $classes = [
        'Новый' => 'badge bg-primary',
        'В обработке' => 'badge bg-warning',
        'Готов' => 'badge bg-info',
        'Доставлен' => 'badge bg-success',
        'Отменен' => 'badge bg-danger'
    ];
    $class = $classes[$status] ?? 'badge bg-secondary';
    return "<span class=\"$class\">" . e($status) . "</span>";
}

// -------------------------
// Подсчёт итоговой суммы корзины
// -------------------------
function cart_total($cart) {
    $total = 0;
    foreach ($cart as $item) {
        $total += $item['price'] * $item['quantity'];
    }
    return $total;
}

// -------------------------
// Применение скидочной карты
// -------------------------
function apply_discount($total, $discount_percent) {
    return $total * (1 - $discount_percent / 100);
}

// -------------------------
// Проверка авторизации пользователя
// -------------------------
function require_login() {
    if (!isset($_SESSION['user_id'])) {
        redirect('/login.php');
    }
}

// -------------------------
// Проверка администратора
// -------------------------
function require_admin() {
    if (!isset($_SESSION['user_role']) || $_SESSION['user_role'] !== 'admin') {
        redirect('/login.php');
    }
}
?>
