<?php
// =========================
// config/logger.php
// Безопасный аудит действий пользователей и админов
// =========================

// Путь к лог-файлу
define('AUDIT_LOG_FILE', __DIR__ . '/../storage/logs/audit.log');

/**
 * Логирование события
 *
 * @param string $type      Тип события: INFO, WARN, ERROR
 * @param int|null $user_id ID пользователя или null
 * @param string $message   Сообщение
 */
function log_event(string $type, ?int $user_id, string $message)
{
    $timestamp = date('Y-m-d H:i:s');
    $user_id_display = $user_id !== null ? $user_id : 'guest';

    // Экранируем новые строки
    $message = str_replace(["\r", "\n"], ' ', $message);

    // Формируем строку лога
    $line = "[$timestamp] $type  User $user_id_display: $message" . PHP_EOL;

    // Безопасная запись в файл
    $logFile = AUDIT_LOG_FILE;

    // Создаем папку если не существует
    if (!file_exists(dirname($logFile))) {
        mkdir(dirname($logFile), 0755, true);
    }

    // Запись с блокировкой
    file_put_contents($logFile, $line, FILE_APPEND | LOCK_EX);
}
