<?php
// =========================
// includes/alerts.php
// =========================

// Этот файл подключается в header.php или main template
// и содержит контейнер для динамических уведомлений через JS (AJAX)

// Контейнер для уведомлений
?>
<div id="alert-container" class="position-fixed top-0 end-0 p-3" style="z-index: 1050;"></div>

<?php
// Функция PHP для вывода уведомлений при рендере страницы
function show_alert($message, $type = 'success', $timeout = 5000) {
    $allowed_types = ['success', 'danger', 'warning', 'info'];
    if (!in_array($type, $allowed_types)) $type = 'success';
    echo <<<HTML
<div class="alert alert-{$type} fade show mb-2" role="alert">
    {$message}
</div>
<script>
    setTimeout(() => {
        const alert = document.currentScript.previousElementSibling;
        if(alert) alert.classList.remove('show');
        setTimeout(()=>alert.remove(), 500);
    }, {$timeout});
</script>
HTML;
}
?>
