<?php
// =========================
// public/index.php
// Главная страница PhotoPrint
// =========================
include __DIR__ . '/../config/bootstrap.php';
include  __DIR__ . '/../config/auth.php';
include  __DIR__ . '/../config/functions.php';

// Получаем доступные форматы печати
$formats = $pdo->query("SELECT * FROM formats ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);

// Подключаем header
include __DIR__ . '/../includes/header.php';
?>

<div class="container py-5">
    <!-- Главный баннер -->
    <div class="jumbotron text-center animate__animated animate__fadeInDown">
        <h1 class="display-4 fw-bold">PhotoPrint</h1>
        <p class="lead">Печать ваших фотографий в любых форматах с доставкой на дом</p>
        <?php if (!is_logged_in()): ?>
            <a href="<?= BASE_URL ?>register.php" class="btn btn-primary btn-lg me-2">Регистрация</a>
            <a href="<?= BASE_URL ?>login.php" class="btn btn-outline-primary btn-lg">Вход</a>
        <?php else: ?>
            <a href="<?= BASE_URL ?>upload.php" class="btn btn-primary btn-lg">Загрузить фото</a>
            <a href="<?= BASE_URL ?>orders.php" class="btn btn-outline-primary btn-lg">Мои заказы</a>
        <?php endif; ?>
    </div>

    <!-- Раздел форматов -->
    <h2 class="mt-5 mb-4 text-center fw-bold animate__animated animate__fadeInUp">Доступные форматы печати</h2>
    <div class="row g-4">
        <?php foreach ($formats as $format): ?>
            <div class="col-md-4">
                <div class="card h-100 shadow-sm border-0 animate__animated animate__fadeInUp">
                    <div class="card-body text-center">
                        <h5 class="card-title"><?= e($format['name']) ?></h5>
                        <p class="card-text fs-5"><?= number_format($format['price'], 2) ?> ₽</p>
                        <?php if (is_logged_in()): ?>
                            <button class="btn btn-success btn-sm add-to-cart" data-format-id="<?= e($format['id']) ?>">Добавить в корзину</button>
                        <?php else: ?>
                            <a href="<?= BASE_URL ?>login.php" class="btn btn-outline-primary btn-sm">Войдите, чтобы заказать</a>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>

    <!-- Информационный блок -->
    <div class="row mt-5 animate__animated animate__fadeInUp">
        <div class="col-md-4 text-center">
            <i class="bi bi-upload fs-1 text-primary"></i>
            <h5 class="mt-3">Загрузите фотографии</h5>
            <p>Поддержка JPG, PNG и других популярных форматов</p>
        </div>
        <div class="col-md-4 text-center">
            <i class="bi bi-cart-check fs-1 text-success"></i>
            <h5 class="mt-3">Выберите формат и параметры</h5>
            <p>Добавляйте фотографии в корзину и оформляйте заказ</p>
        </div>
        <div class="col-md-4 text-center">
            <i class="bi bi-truck fs-1 text-warning"></i>
            <h5 class="mt-3">Получите заказ</h5>
            <p>Доставка прямо к вам домой или в офис</p>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Добавление формата в корзину через AJAX
    const buttons = document.querySelectorAll('.add-to-cart');
    buttons.forEach(btn => {
        btn.addEventListener('click', function() {
            const formatId = this.dataset.formatId;
            fetch('<?= BASE_URL ?>ajax/cart_add.php', {
                method: 'POST',
                headers: {'Content-Type': 'application/x-www-form-urlencoded'},
                body: 'format_id=' + encodeURIComponent(formatId)
            })
            .then(res => res.json())
            .then(data => {
                if(data.success){
                    alert('Формат добавлен в корзину!');
                } else {
                    alert('Ошибка: ' + (data.error || 'Не удалось добавить'));
                }
            });
        });
    });
});
</script>

<?php
// Подключаем footer
include __DIR__ . '/../includes/footer.php';
?>
