<?php
// =========================
// public/index.php
// Главная страница сайта
// =========================




include __DIR__ . '/../config/bootstrap.php';
include __DIR__ . '/../config/auth.php';
include __DIR__ . '/../config/functions.php';

// Подключаем header
include __DIR__ . '/../includes/header.php';
?>

<!-- ========================= -->
<!-- Hero секция -->
<!-- ========================= -->
<section class="bg-light py-5">
    <div class="container text-center">
        <h1 class="display-4 fw-bold animate__animated animate__fadeInDown">PhotoPrint — печать ваших фотографий онлайн</h1>
        <p class="lead mt-3 animate__animated animate__fadeInUp animate__delay-1s">
            Загружайте фото, выбирайте формат и получайте качественные отпечатки быстро и удобно.
        </p>
        <a href="<?= BASE_URL ?>upload.php" class="btn btn-primary btn-lg mt-4 animate__animated animate__fadeInUp animate__delay-2s">
            Загрузить фото
        </a>
    </div>
</section>

<!-- ========================= -->
<!-- Преимущества -->
<!-- ========================= -->
<section class="py-5">
    <div class="container">
        <div class="row g-4">
            <div class="col-md-4">
                <div class="card h-100 shadow-sm border-0 hover-zoom animate__animated animate__fadeInUp">
                    <div class="card-body text-center">
                        <i class="bi bi-speedometer2 display-4 mb-3 text-primary"></i>
                        <h5 class="card-title fw-bold">Быстро</h5>
                        <p class="card-text">Закажите и получите печать всего за несколько дней.</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card h-100 shadow-sm border-0 hover-zoom animate__animated animate__fadeInUp animate__delay-1s">
                    <div class="card-body text-center">
                        <i class="bi bi-camera display-4 mb-3 text-success"></i>
                        <h5 class="card-title fw-bold">Качественно</h5>
                        <p class="card-text">Печать высокого качества на профессиональном оборудовании.</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card h-100 shadow-sm border-0 hover-zoom animate__animated animate__fadeInUp animate__delay-2s">
                    <div class="card-body text-center">
                        <i class="bi bi-lock display-4 mb-3 text-danger"></i>
                        <h5 class="card-title fw-bold">Безопасно</h5>
                        <p class="card-text">Ваши фотографии хранятся и обрабатываются конфиденциально.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- ========================= -->
<!-- CTA секция -->
<!-- ========================= -->
<section class="bg-primary text-white py-5">
    <div class="container text-center">
        <h2 class="fw-bold animate__animated animate__fadeInDown">Готовы сделать заказ?</h2>
        <p class="lead mt-2 animate__animated animate__fadeInUp animate__delay-1s">
            Присоединяйтесь к сотням довольных клиентов прямо сейчас!
        </p>
        <a href="<?= BASE_URL ?>upload.php" class="btn btn-light btn-lg mt-3 animate__animated animate__fadeInUp animate__delay-2s">
            Начать
        </a>
    </div>
</section>

<?php
// Подключаем footer
include __DIR__ . '/../includes/footer.php';
?>
