<?php
// =========================
// public/login.php
// Страница входа пользователя
// =========================

require_once __DIR__ . '/../config/bootstrap.php';
require_once __DIR__ . '/../config/auth.php';
require_once __DIR__ . '/../config/functions.php';

// Если пользователь уже авторизован, редирект на профиль
if (is_logged_in()) {
    redirect(BASE_URL . 'profile.php');
}

$errors = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Проверка CSRF
    $csrf_token = $_POST['csrf_token'] ?? '';
    if (!check_csrf($csrf_token)) {
        $errors[] = 'Ошибка безопасности. Попробуйте снова.';
    } else {
        // Получаем email и пароль
        $email = trim($_POST['email'] ?? '');
        $password = $_POST['password'] ?? '';

        if (empty($email) || empty($password)) {
            $errors[] = 'Заполните все поля.';
        } elseif (!is_valid_email($email)) {
            $errors[] = 'Введите корректный email.';
        } else {
            $res = login_user($pdo, $email, $password);
            if ($res['success']) {
                redirect(BASE_URL . 'profile.php');
            } else {
                $errors[] = $res['error'] ?? 'Ошибка авторизации';
            }
        }
    }
}

// Подключаем header
include __DIR__ . '/../includes/header.php';
?>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-6 col-lg-5">
            <div class="card shadow-sm border-0 animate__animated animate__fadeInDown">
                <div class="card-body p-4">
                    <h3 class="card-title mb-4 text-center fw-bold">Вход в PhotoPrint</h3>

                    <?php
                    // Вывод ошибок
                    if ($errors) {
                        foreach ($errors as $error) {
                            echo '<div class="alert alert-danger mb-2">' . e($error) . '</div>';
                        }
                    }
                    ?>

                    <form method="POST" class="needs-validation" novalidate>
                        <?= csrf_input(); ?>

                        <div class="mb-3">
                            <label for="email" class="form-label">Email</label>
                            <input type="email" class="form-control" id="email" name="email" required value="<?= e($_POST['email'] ?? '') ?>">
                            <div class="invalid-feedback">
                                Введите корректный email
                            </div>
                        </div>

                        <div class="mb-3">
                            <label for="password" class="form-label">Пароль</label>
                            <input type="password" class="form-control" id="password" name="password" required>
                            <div class="invalid-feedback">
                                Введите пароль
                            </div>
                        </div>

                        <button type="submit" class="btn btn-primary w-100 mt-3">Войти</button>
                    </form>

                    <div class="text-center mt-3">
                        <small>Нет аккаунта? <a href="<?= BASE_URL ?>register.php">Зарегистрироваться</a></small>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
// Подключаем footer
include __DIR__ . '/../includes/footer.php';
?>
