<?php
// =========================
// public/upload.php
// Загрузка фотографий для печати
// =========================

require_once __DIR__ . '/../config/bootstrap.php';
require_once __DIR__ . '/../config/auth.php';
require_once __DIR__ . '/../config/functions.php';

// Только авторизованные пользователи
require_login();

$errors = [];
$success = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Проверка CSRF
    $csrf_token = $_POST['csrf_token'] ?? '';
    if (!check_csrf($csrf_token)) {
        $errors[] = 'Ошибка безопасности. Попробуйте снова.';
    } elseif (!isset($_FILES['photo']) || $_FILES['photo']['error'] !== UPLOAD_ERR_OK) {
        $errors[] = 'Ошибка загрузки файла.';
    } else {
        $allowed_types = ['image/jpeg', 'image/png'];
        $file_type = mime_content_type($_FILES['photo']['tmp_name']);

        if (!in_array($file_type, $allowed_types)) {
            $errors[] = 'Разрешены только JPG и PNG файлы.';
        } else {
            $filename = unique_filename($_FILES['photo']['name']);
            $upload_dir = __DIR__ . '/../uploads/photos/';
            
            if (!is_dir($upload_dir)) mkdir($upload_dir, 0755, true);

            if (move_uploaded_file($_FILES['photo']['tmp_name'], $upload_dir . $filename)) {
                // Сохраняем запись в БД
                $stmt = $pdo->prepare("INSERT INTO photos (user_id, filename, uploaded_at, status) VALUES (:user_id, :filename, NOW(), 'Новый')");
                $stmt->execute([
                    'user_id' => $_SESSION['user_id'],
                    'filename' => $filename
                ]);

                $success = true;
            } else {
                $errors[] = 'Не удалось сохранить файл.';
            }
        }
    }
}

// Подключаем header
include __DIR__ . '/../includes/header.php';
?>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-md-6 col-lg-5">
            <div class="card shadow-sm border-0 animate__animated animate__fadeInDown">
                <div class="card-body p-4">
                    <h3 class="card-title mb-4 text-center fw-bold">Загрузка фотографии</h3>

                    <?php if ($success): ?>
                        <div class="alert alert-success mb-3">
                            Файл успешно загружен!
                        </div>
                    <?php endif; ?>

                    <?php
                    // Вывод ошибок
                    if ($errors) {
                        foreach ($errors as $error) {
                            echo '<div class="alert alert-danger mb-2">' . e($error) . '</div>';
                        }
                    }
                    ?>

                    <form method="POST" enctype="multipart/form-data" class="needs-validation" novalidate>
                        <?= csrf_input(); ?>

                        <div class="mb-3">
                            <label for="photo" class="form-label">Выберите фото (JPG, PNG)</label>
                            <input type="file" class="form-control" id="photo" name="photo" accept=".jpg,.jpeg,.png" required>
                            <div class="invalid-feedback">
                                Пожалуйста, выберите файл.
                            </div>
                        </div>

                        <button type="submit" class="btn btn-primary w-100 mt-3">Загрузить</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php
// Подключаем footer
include __DIR__ . '/../includes/footer.php';
?>
